/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GoToMessageOnDistinctPageAction.java,v 1.2 2005/08/13 04:41:39 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.actions.internal;

import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.uml2sd.trace.loaders.TraceInteractions;
import org.eclipse.hyades.uml2sd.trace.selection.IEObjectSelection;
import org.eclipse.hyades.uml2sd.util.SDMessages;
import org.eclipse.hyades.uml2sd.util.SDUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPart;

/**
 * Action to go on associated message that is on another page
 */
public class GoToMessageOnDistinctPageAction extends TraceGraphNodeAction {
	
	/**
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction, org.eclipse.ui.IWorkbenchPart)
	 */
	public void setActivePart(IAction action_, IWorkbenchPart targetPart_) {
		super.setActivePart(action_, targetPart_);
		action_.setText(SDMessages._39); 
		action_.setImageDescriptor(SDUtil.getResourceImage("full/obj16/hide_image_maplist.gif")); //$NON-NLS-1$
	}

	public void run() {
		TraceInteractions.findInvocation((TRCMethodInvocation)((IEObjectSelection)graphNodes.get(0)).getEObject(), false);
	}

}
