/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenObjectInteractions.java,v 1.5 2006/05/16 14:14:02 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.actions.internal;

import java.util.Iterator;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.trace.ui.internal.navigator.ProfileDetailItem;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcesses;

/**
 * Action that opens the object interactions.
 * It exists mainly because the id of the org.eclipse.hyades.ui.analyzerExtensions extension point
 * can not be retrieved.
 */
public class OpenObjectInteractions extends OpenTraceInteractions {

	/**
	 * Not so confortable than the extension id, but an id anyway
	 * Now we know which class is to be instantiated
	 */
	public String getLoaderClassName() {
		return "org.eclipse.hyades.uml2sd.trace.loaders.ObjectInteractions"; //$NON-NLS-1$
	}
	
	public boolean isEnabledForObject(Object obj)
	{
		if (super.isEnabledForObject(obj)) {
			TraceProcesses currentProcesses = getCurrentProcesses(obj);

			if (currentProcesses != null && currentProcesses.size() > 0)
			{
				TRCProcess process;
				Iterator iter = currentProcesses.iterator();
				while (iter.hasNext())
				{
					process = ((TraceProcess)iter.next()).getProcess();
				 
					if (process != null && process.getClassClass() != null && process.getObjects() != null
						 && process.getClassClass().getObjects() != null)
					{
						if (process.getClassClass().getObjects().size() != process.getObjects().size())
							return true;
					}
				}
			}
		}

		return false;
	}
	
	protected TraceProcesses getCurrentProcesses(Object obj)
	{
		if (obj instanceof EObject) {
			TraceProcesses currentProcesses = TraceProcesses.getTraceProcesses((EObject)obj, new IProgressMonitor() {
				public void beginTask(String name, int totalWork) {}
				public void done() {}
				public void internalWorked(double work) {}
				public boolean isCanceled() {return false;}
				public void setCanceled(boolean value) {}
				public void setTaskName(String name) {}
				public void subTask(String name) {}
				public void worked(int work) {}});
					
			return currentProcesses;
		}
		else if (obj instanceof ProfileDetailItem)
			return getCurrentProcesses(((ProfileDetailItem)obj).getParent());
		
		return null;
	}
}
