/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenTraceInteractions.java,v 1.9 2006/05/16 14:14:02 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.actions.internal;

import java.util.Iterator;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.actions.OpenAssociatedTraceViewAction;
import org.eclipse.hyades.trace.ui.internal.navigator.ProfileDetailItem;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.uml2sd.trace.TraceSDUtil;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

/**
 * The abstract action that offers to help opening a trace interaction.
 */
public abstract class OpenTraceInteractions extends OpenAssociatedTraceViewAction
				implements IWorkbenchWindowActionDelegate, IViewActionDelegate {
			
	private final String VIEW_ID="org.eclipse.hyades.uml2sd.ui.view.SDView"; //$NON-NLS-1$
	/**
	 * OpenReferencePatternView constructor comment.
	 */
	public OpenTraceInteractions() {
		super(""); //$NON-NLS-1$
	}
	/**
	 * OpenReferencePatternView constructor comment.
	 * @param label java.lang.String
	 */
	public OpenTraceInteractions(String label) {
		super(label);
	}
	/**
	 * OpenReferencePatternView constructor comment.
	 * @param label java.lang.String
	 * @param image org.eclipse.jface.parts.IImage
	 */
	public OpenTraceInteractions(String label, ImageDescriptor image) {
		super(label, image);
	}

	/**
	 * 
	 */
	public boolean isVisibleForType(Object mofObject) {
		return mofObject instanceof TRCProcess;
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		IWorkbenchWindow window =
			UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();

		try {
			IWorkbenchPage persp = UIPlugin.getActivePage();
			SDView view = (SDView) persp.showView(TraceSDUtil.UML2SD_TRACE_VIEW_ID);
			LoadersManager.getLoadersManager().createLoader(getLoaderClassName(), getClass().getClassLoader(), view);
		} catch (Exception e) {
			String msg = TraceUIMessages._153; //$NON-NLS-1$
			Status err =
				new Status(
					Status.WARNING,
					ResourcesPlugin.PI_RESOURCES,
					IResourceStatus.INTERNAL_ERROR,
					e.toString(),
					null);

			ErrorDialog.openError(window.getShell(), msg, "", //$NON-NLS-1$
			// no special message
			err);

			e.printStackTrace();
		}
	}
	
	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		run();
	}
	
	/**
	 * The abstract to be implemented by concrete trace interactions opening actions.
	 * This is the way to know which concrete class is to be instantiated as a loader.
	 * It exists mainly because the id of the org.eclipse.hyades.ui.analyzerExtensions extension point
	 * can not be retrieved.
	 */
	public abstract String getLoaderClassName();

	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window) {
	}
	
	/**
	 * Initializes this action delegate with the view it will work in.
	 * @param view the view that provides the context for this delegate
	 */
	public void init(IViewPart view) {
		// try to figure out what do the commented two lines above mean???
	}

	/**
	 * Looks like a dispose...
	 */
	public void dispose() {
		// nothing to do today
	}
	public String getViewID() {
		return VIEW_ID;
	}
	
	protected boolean checkEObjectCollectionMode(Object obj)
	{
		if (obj instanceof EObject) {
			return checkCollectionMode((EObject)obj);
		}
		else if (obj instanceof ProfileDetailItem)
			return checkEObjectCollectionMode(((ProfileDetailItem)obj).getParent());
		
		return true;
	}
	
	public boolean isEnabledForObject(Object obj)
	{
		return checkEObjectCollectionMode(obj);
	}
	
	public boolean checkCollectionMode(EObject object) {
		if (object instanceof TRCMonitor) {
			TRCMonitor m = (TRCMonitor)object;
			if (m.getNodes() == null ||
				m.getNodes().isEmpty()) {
				return false;
			}
			for (Iterator i = m.getNodes().iterator(); i.hasNext();) {
				if (checkCollectionMode((EObject)i.next()))
					return true;
			}
		} else if (object instanceof TRCNode) {
			TRCNode n = (TRCNode)object;
			if (n.getProcessProxies() == null ||
				n.getProcessProxies().isEmpty()) {
				return false;
			}
			for (Iterator i = n.getProcessProxies().iterator(); i.hasNext();) {
				if (checkCollectionMode((EObject)i.next()))
					return true;
			}
		} else if (object instanceof TRCProcessProxy) {
			TRCProcessProxy pp = (TRCProcessProxy)object;
			if (pp.getAgentProxies() == null ||
				pp.getAgentProxies().isEmpty()) {
				return false;
			}
			for (Iterator i = pp.getAgentProxies().iterator(); i.hasNext(); ) {
				if (checkCollectionMode((EObject)i.next()))
					return true;
			}
		} else if (object instanceof TRCAgentProxy &&
				   ((TRCAgentProxy) object).getType().equals(HyadesConstants.PROFILE_AGENT_TYPE)) {
			TRCAgentProxy agentProxy = ((TRCAgentProxy) object);
			if (agentProxy.getCollectionMode() == TRCCollectionMode.EXECUTION_FULL_LITERAL ||
					agentProxy.getCollectionMode() == TRCCollectionMode.EXECUTION_NO_INSTANCES_LITERAL || 
					agentProxy.getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL ||
					agentProxy.getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES_LITERAL ) {
				return true;
			}
			else {
				return false;
			}
		}
		return false;
	}
}
