/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: UndoDrillDownMenuAction.java,v 1.1 2005/09/26 12:42:36 sduguet Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.actions.internal;

import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.uml2sd.trace.TraceSDUtil;
import org.eclipse.hyades.uml2sd.trace.loaders.TraceInteractions;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

/**
 * Action to reset all the currently applied drill down actions
 *
 */
public class UndoDrillDownMenuAction extends Action implements IViewActionDelegate {
	
	public static final String ACTIONS_UNDODRILLDOWNMENUACTION = "org.eclipse.hyades.uml2sd.trace.actions.internal.UndoDrillDownMenuAction"; //$NON-NLS-1$

	private final class UndoDrillDownMenuCreator implements IMenuCreator {
		
		private Menu menu;

		public void dispose() {
			if (menu != null) {
				menu.dispose();
			}
		}

		public Menu getMenu(Control parent) {
			if (menu != null) {
				menu.dispose();
			}
			menu = new Menu(parent);
			addActionToMenu(menu, backLastDrillDown);
			addActionToMenu(menu, resetDrillDown);
			return menu;
		}

		protected void addActionToMenu(Menu parent, Action action) {
			ActionContributionItem item = new ActionContributionItem(action);
			item.fill(parent, -1);
		}

		public Menu getMenu(Menu parent) {
			return null;
		}
	}

	private Action backLastDrillDown;
	private Action resetDrillDown;
	
	public UndoDrillDownMenuAction() {
		setText(TraceUIMessages._229);
		setToolTipText(TraceUIMessages._229);
		setId(ACTIONS_UNDODRILLDOWNMENUACTION);
		setImageDescriptor(TraceSDUtil.getResourceImageDescriptor("full/etool16/reset_drill_down_co.gif")); //$NON-NLS-1$
		setDisabledImageDescriptor(TraceSDUtil.getResourceImageDescriptor("full/dtool16/reset_drill_down_co.gif")); //$NON-NLS-1$
		backLastDrillDown = new Action(TraceUIMessages._230) {
			public void run() { TraceInteractions.getInstance().backLastDrillDown(); };
		};
		backLastDrillDown.setImageDescriptor(TraceSDUtil.getResourceImageDescriptor("full/etool16/back_last_drill_down_co.gif")); //$NON-NLS-1$
		backLastDrillDown.setDisabledImageDescriptor(TraceSDUtil.getResourceImageDescriptor("full/etool16/back_last_drill_down_co.gif")); //$NON-NLS-1$
		resetDrillDown = new Action(TraceUIMessages._229) {
			public void run() { TraceInteractions.getInstance().resetDrillDown(); };
		};
		resetDrillDown.setImageDescriptor(TraceSDUtil.getResourceImageDescriptor("full/etool16/reset_drill_down_co.gif")); //$NON-NLS-1$
		resetDrillDown.setDisabledImageDescriptor(TraceSDUtil.getResourceImageDescriptor("full/dtool16/reset_drill_down_co.gif")); //$NON-NLS-1$
		setMenuCreator(new UndoDrillDownMenuCreator());
	}

	public void init(IViewPart view) {
	}
	
	public void setEnabled(boolean enabled) {
		super.setEnabled(enabled);
		backLastDrillDown.setEnabled(enabled);
		resetDrillDown.setEnabled(enabled);
	}

	public void run() {
		// Default is reset
		TraceInteractions.getInstance().resetDrillDown();
	}

	public void run(IAction action) {
		run();
	}

	public void selectionChanged(IAction action, ISelection selection) {
		// Nothing to do
	}

	public IAction getBackLastDrillDownAction() {
		return backLastDrillDown;
	}

	public IAction getResetDrillDownAction() {
		return resetDrillDown;
	}

}
