/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseLifelineLoader.java,v 1.4 2005/08/13 04:43:07 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;


/**
 * Base class for all the lifeline loaders (see ILifelineLoader) for Trace Interactions features.
 */
abstract public class BaseLifelineLoader implements ILifelineLoader, IUml2SDLoader {
	
	protected ILifelineLoader parent;
	
	public ILifelineLoader getParent() {
		return parent;
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader#setViewer(org.eclipse.hyades.uml2sd.ui.view.SDView)
	 */
	public void setViewer(SDView viewer) {
		TraceInteractions.getInstance().setLifelineLoader(this);
		TraceInteractions.getInstance().setViewer(viewer);
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader#getTitleString()
	 */
	public String getTitleString() {
		return TraceInteractions.getInstance().getTitleString();
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader#aboutToBeReplaced()
	 */
	public void aboutToBeReplaced() {
		TraceInteractions.getInstance().aboutToBeReplaced();
	}
	
	/**
	 * Default implementation for the lifeline loaders that does allow drill down
	 */
	public boolean drillDownEnabled(String value) {
		return "true".equalsIgnoreCase(value); //$NON-NLS-1$
	}
	
	/**
	 * @return a string carrying the message type
	 */
	public String getMessageTypeName() {
		return TraceUIMessages._146; //$NON-NLS-1$
	}


}
