/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NodeInteractions.java,v 1.5 2005/09/23 07:57:36 sduguet Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;

/**
 * This class aims to populate a Node (host) Interaction UML2 Sequence Diagram.
 */
public class NodeInteractions extends BaseLifelineLoader {
	
	/**
	 * Constructor
	 */
	public NodeInteractions() {
		parent = null;
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifelineEObjectFromMethodInvocation(org.eclipse.hyades.models.trace.TRCFullMethodInvocation)
	 */
	public EObject getLifelineEObjectFromMethodInvocation(
			TRCFullMethodInvocation mi) {
		return mi.getProcess().getAgent().getAgentProxy().getProcessProxy().getNode(); // TRCNode
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifeLineCategory(org.eclipse.emf.ecore.EObject)
	 */
	public int getLifeLineCategory(EObject to) {
		return TraceInteractions.CATEGORY_NODE;
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifeLineTitle(org.eclipse.emf.ecore.EObject, boolean)
	 */
	public String getLifeLineTitle(EObject to, boolean long_) {
		TRCNode node = (TRCNode)to;
		return node.getName(); //$NON-NLS-1$
	}

	/**
	 * Returns the distinguishedtitle of a lifeline
	 * @param eo the EObject denoting this lifeline
	 * @param rank its rank
	 * @return the distinguished title of the lifeline
	 */
	public String getDistinguishedLifeLineTitle(EObject eo, int rank) {
		return getLifeLineTitle(eo, true) + " #" + rank; //$NON-NLS-1$
	}

	/**
	 * The host runtime id
	 */
	public String getLifeLineId(EObject eo) {
		return ((TRCNode)eo).getRuntimeId()+"#"+getLifeLineTitle(eo, true); //$NON-NLS-1$
	}
	
	/**
	 * This is the nose interactions, nothing else
	 */
	public String getFinalTitleString() {
		return TraceUIPlugin.getResourceString("37"); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifelineType(org.eclipse.emf.ecore.EObject)
	 */
	public String getLifelineType(EObject eObject) {
		return TraceUIMessages._139; //$NON-NLS-1$;
	}

	/**
	 * @return a string carrying the lifeline type
	 */
	public String getLifelineTypeName() {
		return TraceUIMessages._139; //$NON-NLS-1$;
	}

}
