/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ThreadInteractions.java,v 1.7 2005/10/19 11:35:14 sduguet Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;

/**
 * This class aims to populate a Thread Interaction UML2 Sequence Diagram.
 */
public class ThreadInteractions extends BaseLifelineLoader {
	
	/**
	 * Constructor
	 */
	public ThreadInteractions() {
		parent = new AgentInteractions();
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifelineEObjectFromMethodInvocation(org.eclipse.hyades.models.trace.TRCFullMethodInvocation)
	 */
	public EObject getLifelineEObjectFromMethodInvocation(
			TRCFullMethodInvocation mi) {
		return mi.getThread(); // TRCThread
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifeLineCategory(org.eclipse.emf.ecore.EObject)
	 */
	public int getLifeLineCategory(EObject to) {
		return TraceInteractions.CATEGORY_THREAD;
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifeLineTitle(org.eclipse.emf.ecore.EObject, boolean)
	 */
	public String getLifeLineTitle(EObject to, boolean long_) {
		TRCThread thread = (TRCThread)to;
		return thread.getName(); // no longer using TraceUIMessages._140
	}

	/**
	 * Returns the distinguishedtitle of a lifeline
	 * @param eo the EObject denoting this lifeline
	 * @param rank its rank
	 * @return the distinguished title of the lifeline
	 */
	public String getDistinguishedLifeLineTitle(EObject eo, int rank) {
		TRCThread thread = (TRCThread)eo;
		return getLifeLineTitle(eo, true) + " ["+thread.getProcess().getPid()+"]"; //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * The runtimeId of agentProxy and the lifeline title
	 */
	public String getLifeLineId(EObject eo) {
		TRCAgentProxy ap;
		ap = ((TRCThread)eo).getProcess().getAgent().getAgentProxy();
		return ap.getRuntimeId()+"#"+getLifeLineTitle(eo, true); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getFinalTitleString()
	 */
	public String getFinalTitleString() {
		return TraceUIPlugin.getResourceString("40"); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifelineType(org.eclipse.emf.ecore.EObject)
	 */
	public String getLifelineType(EObject eObject) {
		return TraceUIMessages._142; //$NON-NLS-1$;
	}

	/**
	 * @return a string carrying the lifeline type
	 */
	public String getLifelineTypeName() {
		return TraceUIMessages._142; //$NON-NLS-1$;
	}

}
