/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseTraceProperty.java,v 1.1 2005/07/22 14:49:34 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.List;

import org.eclipse.hyades.uml2sd.trace.loaders.TraceInteractions;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetEntryListener;

/**
 *
 */
public class BaseTraceProperty implements IPropertySheetEntry {

	private String name;
	
	public BaseTraceProperty(String name_) {
		name = name_;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#addPropertySheetEntryListener(org.eclipse.ui.views.properties.IPropertySheetEntryListener)
	 */
	public void addPropertySheetEntryListener(
			IPropertySheetEntryListener listener) {
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#applyEditorValue()
	 */
	public void applyEditorValue() {
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#dispose()
	 */
	public void dispose() {
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getCategory()
	 */
	public String getCategory() {
		return null;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getChildEntries()
	 */
	public IPropertySheetEntry[] getChildEntries() {
		return null;
	}

	private IPropertiesMiner getSelection() {
		try {
			List selection = TraceInteractions.getInstance().getView().getSDWidget().getSelection();
			if (selection == null || selection.size() == 0) {
				return null;
			}
			return (IPropertiesMiner)selection.get(selection.size()-1);
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getDescription()
	 */
	public String getDescription() {
		IPropertiesMiner selection = getSelection();
		return selection != null ? selection.getDescription(name) : ""; //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getDisplayName()
	 */
	public String getDisplayName() {
		IPropertiesMiner selection = getSelection();
		return selection != null ? selection.getDisplayName(name) : ""; //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getValueAsString()
	 */
	public String getValueAsString() {
		IPropertiesMiner selection = getSelection();
		return selection != null ? selection.getValueAsString(name) : ""; //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getEditor(org.eclipse.swt.widgets.Composite)
	 */
	public CellEditor getEditor(Composite parent) {
		return null;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getErrorText()
	 */
	public String getErrorText() {
		return null;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getFilters()
	 */
	public String[] getFilters() {
		return null;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getHelpContextIds()
	 */
	public Object getHelpContextIds() {
		return null;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getImage()
	 */
	public Image getImage() {
		return null;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#hasChildEntries()
	 */
	public boolean hasChildEntries() {
		return false;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#removePropertySheetEntryListener(org.eclipse.ui.views.properties.IPropertySheetEntryListener)
	 */
	public void removePropertySheetEntryListener(
			IPropertySheetEntryListener listener) {
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#resetPropertyValue()
	 */
	public void resetPropertyValue() {
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#setValues(java.lang.Object[])
	 */
	public void setValues(Object[] values) {
	}

}
