/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceCollapsedLifelines.java,v 1.1 2005/07/22 14:49:35 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.ArrayList;

/**
 * Collapsed Lifelines are stored here and are shown as one Lifeline
 */
public class TraceCollapsedLifelines extends TraceLifeline {

	private ArrayList collapsedLifelines;
	
	public void setCollapsedLifelines(ArrayList collapsedLifelines_) {
		collapsedLifelines = collapsedLifelines_;
	}
	
	public ArrayList getCollapsedLifelines() {
		return collapsedLifelines;
	}
	
	public boolean contains(Object key) {
		return collapsedLifelines.contains(key);
	}
	
}
