/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceCollapsedSyncMessage.java,v 1.1 2005/07/22 14:49:35 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import org.eclipse.hyades.uml2sd.trace.TraceSDUtil;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ImageImpl;

/**
 * For TraceUIMessages that have been collapsed
 */
public class TraceCollapsedSyncMessage extends TraceSyncMessage implements IExpandableMessage {
	
	/**
	 * <code>image</code> is drawn on top of the message near its arrow
	 */
	static IImage image;
	static {
		image = new ImageImpl(TraceSDUtil.getResourceImage("full/cview16/collapsed_message.gif")); //$NON-NLS-1$
	}
	
	static int deltaX(int width, BaseMessage m) {
		int ret = width;
		ret += width >= 0 ? -19 : 10;
		if (m.getEndLifeline() == null && m instanceof SyncMessageReturn) {
			ret -= 6;
		}
		if (m.getStartLifeline() == m.getEndLifeline()) {
			ret += 10;
		}
		return ret;
	}
	
	static int deltaY(BaseMessage m) {
		int ret = 2;
		if (m.getStartLifeline() == m.getEndLifeline()) {
			ret -= 14;
		}
		return ret;
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.ui.core.BaseMessage#draw(org.eclipse.hyades.uml2sd.ui.drawings.IGC)
	 */
	public void draw(IGC context) {
		super.draw(context);
		if (image != null) {
			int x = getX();
			int y = getY();
			int width = getWidth();
			x += deltaX(width, this);
			y += deltaY(this);
			if (isSelected()) {
				context.setForeground(Frame.getUserPref().getBackGroundColorSelection());
				context.setLineWidth(Metrics.SELECTION_LINE_WIDTH);
				context.drawRectangle(x+1, y+1, 8, 8);
				context.setBackground(Frame.getUserPref().getBackGroundColorSelection());
				context.setForeground(Frame.getUserPref().getForeGroundColorSelection());
				context.setLineWidth(Metrics.NORMAL_LINE_WIDTH);
			}
			context.drawImage(image, x, y, 11, 11);
		}
	}
}
