/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceCollapsedSyncMessageReturn.java,v 1.1 2005/07/22 14:49:35 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;

/**
 * For messages that have been collapsed
 */
public class TraceCollapsedSyncMessageReturn extends TraceSyncMessageReturn
	implements IExpandableMessage {
	
	/**
	 * @see org.eclipse.hyades.uml2sd.ui.core.BaseMessage#draw(org.eclipse.hyades.uml2sd.ui.drawings.IGC)
	 */
	public void draw(IGC context) {
		super.draw(context);
		if (TraceCollapsedSyncMessage.image != null) {
			int x = getX();
			int y = getY();
			int width = getWidth();
			x += TraceCollapsedSyncMessage.deltaX(width, this);
			y += TraceCollapsedSyncMessage.deltaY(this);
			if (isSelected()) {
				context.setForeground(Frame.getUserPref().getBackGroundColorSelection());
				context.setLineWidth(Metrics.SELECTION_LINE_WIDTH);
				context.drawRectangle(x+1, y+1, 8, 8);
				context.setBackground(Frame.getUserPref().getBackGroundColorSelection());
				context.setForeground(Frame.getUserPref().getForeGroundColorSelection());
				context.setLineWidth(Metrics.NORMAL_LINE_WIDTH);
			}
			context.drawImage(TraceCollapsedSyncMessage.image, x, y, 11, 11);
		}
	}

}
