/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceInteractionUpdate.java,v 1.2 2005/09/26 12:42:37 sduguet Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.ArrayList;

import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;

/**
 * A place where go commands to the translation algorithm from model to UML2SD.
 */
public class TraceInteractionUpdate {
	
	private boolean lifelineLoaderChanged;

	private GraphNode visibleGraphNode;
	private GraphNode previousVisibleGraphNode;
	private int visibleX;
	
	private boolean pageChanged;
	private boolean maxMessagesByPageChanged;
	
	private boolean internalMessageFilteringChanged;
	
	private boolean findRequired;
	private ArrayList findResults;
	private Criteria findCriteria;
	private int findStartingPage;

	private boolean filteringChanged;
	
	private boolean dateSelectionChanged;
	private boolean externalDateSelectionChanged;
	private double dateToShow;
	
	private boolean horizontalCollapsingChanged;
	private boolean verticalCollapsingChanged;
	
	private boolean findInvocationRequired;
	private TRCMethodInvocation findInvocationModel;
	private boolean findInvocationReturn;
	private ITraceMessage findInvocationResult;
	
	public TraceInteractionUpdate() {
	}
	
	public boolean needsUpdate() {
		return lifelineLoaderChanged ||
			   pageChanged ||
			   internalMessageFilteringChanged ||
			   findRequired ||
			   filteringChanged ||
			   dateSelectionChanged ||
			   isHorizontalCollapsingChanged() ||
			   isVerticalCollapsingChanged();
	}

	public void setLifelineLoaderChanged(boolean lifelineLoaderChanged_) {
		lifelineLoaderChanged = lifelineLoaderChanged_;
	}

	public boolean isLifelineLoaderChanged() {
		return lifelineLoaderChanged;
	}

	public void setVisibleGraphNode(GraphNode visibleGraphNode_) {
		visibleGraphNode = visibleGraphNode_;
	}
	public GraphNode getVisibleGraphNode() {
		return visibleGraphNode;
	}

	public void setPreviousVisibleGraphNode(GraphNode visibleGraphNode_) {
		previousVisibleGraphNode = visibleGraphNode_;
	}
	public GraphNode getPreviousVisibleGraphNode() {
		return previousVisibleGraphNode;
	}

	public void setVisibleX(int visibleX_) {
		visibleX = visibleX_;
	}

	public int getVisibleX() {
		return visibleX;
	}

	public void setPageChanged(boolean pageChanged_) {
		pageChanged = pageChanged_;
	}
	public boolean isPageChanged() {
		return pageChanged;
	}
	
	public void setMaxMessagesByPageChanged(boolean maxMessagesByPageChanged_) {
		maxMessagesByPageChanged = maxMessagesByPageChanged_;
	}

	public boolean isMaxMessagesByPageChanged() {
		return maxMessagesByPageChanged;
	}

	public void setInternalMessageFilteringChanged(boolean internalMessageFilteringChanged_) {
		internalMessageFilteringChanged = internalMessageFilteringChanged_;
	}
	public boolean isInternalMessageFilteringChanged() {
		return internalMessageFilteringChanged;
	}

	public void setFindRequired(boolean findRequired_) {
		findRequired = findRequired_;
	}
	public boolean isFindRequired() {
		return findRequired;
	}
	public void addFindResult(GraphNode findResult) {
		if (findResults == null) {
			findResults = new ArrayList();
		}
		findResults.add(findResult);
	}
	public ArrayList getFindResults() {
		return findResults;
	}

	public void setFilteringChanged(boolean filteringChanged_) {
		filteringChanged = filteringChanged_;
	}
	public boolean isFilteringChanged() {
		return filteringChanged;
	}

	public void setFindCriteria(Criteria findCriteria_) {
		findCriteria = findCriteria_;
	}
	public Criteria getFindCriteria() {
		return findCriteria;
	}

	public void setFindStartingPage(int findStartingPage_) {
		findStartingPage = findStartingPage_;
	}

	public int getFindStartingPage() {
		return findStartingPage;
	}

	public void setDateSelectionChanged(boolean dateSelectionChanged_) {
		dateSelectionChanged = dateSelectionChanged_;
	}
	public boolean isDateSelectionChanged() {
		return dateSelectionChanged;
	}
	public void setExternalDateSelectionChanged(boolean dateExternalSelectionChanged_) {
		externalDateSelectionChanged = dateExternalSelectionChanged_;
	}
	public boolean isExternalDateSelectionChanged() {
		return externalDateSelectionChanged;
	}
	public void setDateToShow(double dateToShow_) {
		dateToShow = dateToShow_;
	}
	public double getDateToShow() {
		return dateToShow;
	}

	public void setHorizontalCollapsingChanged(boolean horizontalCollapsingChanged_) {
		horizontalCollapsingChanged = horizontalCollapsingChanged_;
	}
	public boolean isHorizontalCollapsingChanged() {
		return horizontalCollapsingChanged;
	}

	public void setVerticalCollapsingChanged(boolean verticalCollapsingChanged_) {
		verticalCollapsingChanged = verticalCollapsingChanged_;
	}
	public boolean isVerticalCollapsingChanged() {
		return verticalCollapsingChanged;
	}

	public void setFindInvocationRequired(boolean findInvocationRequired_) {
		findInvocationRequired = findInvocationRequired_;
	}
	public boolean isFindInvocationRequired() {
		return findInvocationRequired;
	}
	public void setFindInvocationModel(TRCMethodInvocation findInvocationModel_) {
		findInvocationModel = findInvocationModel_;
	}
	public TRCMethodInvocation getFindInvocationModel() {
		return findInvocationModel;
	}
	public void setFindInvocationReturn(boolean findInvocationReturn_) {
		findInvocationReturn = findInvocationReturn_;
	}
	public boolean isFindInvocationReturn() {
		return findInvocationReturn;
	}
	public void setFindInvocationResult(ITraceMessage findInvocationResult_) {
		findInvocationResult = findInvocationResult_;
	}
	public ITraceMessage getFindInvocationResult() {
		return findInvocationResult;
	}

}