/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceMessageAndCallAssociation.java,v 1.1 2005/07/22 14:49:35 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;

/**
 * Association between a SyncMessage and its TRCFullMethodInvocation
 */
public class TraceMessageAndCallAssociation {
	
	private SyncMessage message;
	private TRCFullMethodInvocation methodInvocation;
	
	public TraceMessageAndCallAssociation(SyncMessage message_, 
										  TRCFullMethodInvocation methodInvocation_) {
		setMessage(message_);
		setMethodInvocation(methodInvocation_);
	}

	/**
	 * @param message
	 */
	public void setMessage(SyncMessage message) {
		this.message = message;
	}
	/**
	 * @return
	 */
	public SyncMessage getMessage() {
		return message;
	}
	
	/**
	 * @param methodInvocation
	 */
	public void setMethodInvocation(TRCFullMethodInvocation methodInvocation) {
		this.methodInvocation = methodInvocation;
	}
	/**
	 * @return
	 */
	public TRCFullMethodInvocation getMethodInvocation() {
		return methodInvocation;
	}
}
