/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceRootProperty.java,v 1.1 2005/07/22 14:49:35 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetEntryListener;

/**
 * 
 */
public class TraceRootProperty implements IPropertySheetEntry {

	public static final String STR_TYPE = "Type"; //$NON-NLS-1$
	public static final String STR_NAME = "Name"; //$NON-NLS-1$
	public static final String STR_TIME = "Time"; //$NON-NLS-1$
	private IPropertySheetEntry[] childs;
	
	public TraceRootProperty() {
		childs = new IPropertySheetEntry[3];
		childs[0] = new BaseTraceProperty(STR_TYPE);
		childs[1] = new BaseTraceProperty(STR_NAME);
		childs[2] = new BaseTraceProperty(STR_TIME);
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#addPropertySheetEntryListener(org.eclipse.ui.views.properties.IPropertySheetEntryListener)
	 */
	public void addPropertySheetEntryListener(IPropertySheetEntryListener listener) {
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#applyEditorValue()
	 */
	public void applyEditorValue() {
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#dispose()
	 */
	public void dispose() {
		if (childs != null) {
			for (int i = 0; i < childs.length; i++) {
				childs[i].dispose();
			}
			childs = null;
		}
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getCategory()
	 */
	public String getCategory() {
		return null;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getChildEntries()
	 */
	public IPropertySheetEntry[] getChildEntries() {
		return childs;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getDescription()
	 */
	public String getDescription() {
		return null;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getDisplayName()
	 */
	public String getDisplayName() {
		return null;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getEditor(org.eclipse.swt.widgets.Composite)
	 */
	public CellEditor getEditor(Composite parent) {
		return null;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getErrorText()
	 */
	public String getErrorText() {
		return null;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getFilters()
	 */
	public String[] getFilters() {
		return null;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getHelpContextIds()
	 */
	public Object getHelpContextIds() {
		return null;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getImage()
	 */
	public Image getImage() {
		return null;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#getValueAsString()
	 */
	public String getValueAsString() {
		return null;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#hasChildEntries()
	 */
	public boolean hasChildEntries() {
		return true;
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#removePropertySheetEntryListener(org.eclipse.ui.views.properties.IPropertySheetEntryListener)
	 */
	public void removePropertySheetEntryListener(IPropertySheetEntryListener listener) {
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#resetPropertyValue()
	 */
	public void resetPropertyValue() {
	}

	/**
	 * @see org.eclipse.ui.views.properties.IPropertySheetEntry#setValues(java.lang.Object[])
	 */
	public void setValues(Object[] values) {
	}

}
