/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceSyncMessage.java,v 1.4 2005/08/13 04:43:07 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.uml2sd.trace.selection.IDateSelection;
import org.eclipse.hyades.uml2sd.trace.selection.IEObjectSelection;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.util.TimeUtil;
import org.eclipse.ui.IActionFilter;


/**
 * Here is a message
 */
public class TraceSyncMessage extends SyncMessage
		implements IDateSelection, ITraceMessage, IActionFilter, IEObjectSelection, IPropertiesMiner {
	
	public TRCFullMethodInvocation model;
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.selection.IDateSelection#getMeaning()
	 */
	public int getMeaning() {
		return IDateSelection.NOW;
	}
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.selection.IDateSelection#getStartDate()
	 */
	public double getStartDate() {
		return model == null ? 0 : model.getEntryTime();
	}
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.selection.IDateSelection#getEndDate()
	 */
	public double getEndDate() {
		return getStartDate();
	}
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.selection.IEObjectSelection#getEObject()
	 */
	public EObject getEObject() {
		return model;
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.internal.IPropertiesMiner#getDescription(java.lang.String)
	 */
	public String getDescription(String propertyName) {
		if (propertyName.equals(TraceRootProperty.STR_TYPE)) {
			return TraceUIMessages._163; //$NON-NLS-1$
		} else if (propertyName.equals(TraceRootProperty.STR_NAME)) {
			return TraceUIMessages._165; //$NON-NLS-1$
		} else if (propertyName.equals(TraceRootProperty.STR_TIME)) {
			return TraceUIMessages._167; //$NON-NLS-1$
		}
		return propertyName;
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.internal.IPropertiesMiner#getDisplayName(java.lang.String)
	 */
	public String getDisplayName(String propertyName) {
		if (propertyName.equals(TraceRootProperty.STR_TYPE)) {
			return TraceUIMessages._164; //$NON-NLS-1$
		} else if (propertyName.equals(TraceRootProperty.STR_NAME)) {
			return TraceUIMessages._166; //$NON-NLS-1$
		} else if (propertyName.equals(TraceRootProperty.STR_TIME)) {
			return TraceUIMessages._168; //$NON-NLS-1$
		}
		return propertyName;
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.internal.IPropertiesMiner#getValueAsString(java.lang.String)
	 */
	public String getValueAsString(String propertyName) {
		if (propertyName.equals(TraceRootProperty.STR_TYPE)) {
			return TraceUIMessages._169; //$NON-NLS-1$
		} else if (propertyName.equals(TraceRootProperty.STR_NAME)) {
			TRCFullMethodInvocation mi = ((TRCFullMethodInvocation)model);
			TRCClass clazz;
			if (mi.getOwningObject().getIsA() == mi.getProcess().getClassClass())
				clazz = mi.getMethod().getDefiningClass(); // TRCClass
			else {
				clazz = mi.getOwningObject().getIsA(); // TRCTraceObject
			}
			return clazz.getName()+"."+mi.getMethod().getName()+mi.getMethod().getSignature(); //$NON-NLS-1$
		} else if (propertyName.equals(TraceRootProperty.STR_TIME)) {
			TRCFullMethodInvocation mi = ((TRCFullMethodInvocation)model);
			return TimeUtil.timeToString(mi.getEntryTime());
		}
		// Unknown property
		return ""; //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.ui.IActionFilter#testAttribute(java.lang.Object, java.lang.String, java.lang.String)
	 */
	public boolean testAttribute(Object target, String name, String value) {
		if (name.equals("goToMessageReturnOnDistinctPage")) { //$NON-NLS-1$
			return Boolean.toString(((TraceSyncMessage)target).getMessageReturn() == null &&
				    ((TraceSyncMessage)target).model.getExitTime() != 0.0).equalsIgnoreCase(value);
		}
		// Any other property is ignored
		return true;
	}

}