/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDateSelection.java,v 1.1 2005/07/22 14:49:38 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.selection;

/**
 * An interface to be implemented by selectable objects that represents a date or a date range
 */
public interface IDateSelection extends IEObjectSelection {
	
	/**
	 * <ul>The predefined meanings for a date selection:
	 * <li>NOW: the selection represents a single date the user is focusing on
	 * <li>VISIBLE_RANGE: the selection represents the visible time window the user is focusing on,
	 *     by its starting and end dates
	 * <li>GLOBAL_RANGE: the selection represents the full time window the user can navigate through
	 *     by its starting and end dates
	 * </ul><br>
	 * It is ensured by the Selection Provider that the start date is before the end date.<br>
	 * Dates are of type double, as in the Hyades Trace model.
	 */
	public static final int NOW = 0;
	public static final int VISIBLE_RANGE = 1;
	public static final int GLOBAL_RANGE = 2;
	
	/**
	 * Returns the meaning of this date selection, from the list above
	 */
	public int getMeaning();
	
	/**
	 * When the meaning is NOW, returns this NOW time.<br>
	 * When it is VISIBLE_RANGE or GLOBAL_RANGE, returns the lowest date of the range.
	 */
	public double getStartDate();
	
	/**
	 * When the meaning is NOW, returns unpredictable results.<br>
	 * When it is VISIBLE_RANGE or GLOBAL_RANGE, returns the highest time of the range.
	 */
	public double getEndDate();
	
}
