/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BIRTReportsWizard.java,v 1.9 2008/04/10 14:53:39 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.tptp.platform.report.birt.ui.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.ui.report.ReportGeneratorWizard;
import org.eclipse.tptp.platform.report.birt.core.provisional.IReportElement;

public abstract class BIRTReportsWizard extends ReportGeneratorWizard {
    public final static String EDITOR_ID = "org.eclipse.ui.browser.editorSupport";//$NON-NLS-1$

    protected abstract IFile getReportFile();
    
    protected abstract IReportElement getReportElement();
    
	protected void initGenerate() {
		// TODO Auto-generated method stub		
	}

    
    /**
     * All BIRT reports should open up the internal web browser.
     * @return
     */
	public String getEditorId() {	
		return EDITOR_ID;
	}  
	
    public IFile generate(IProgressMonitor monitor) throws Exception {
    	initGenerate();
    	IReportElement reportElement = getReportElement();
		if (reportElement == null)return null;
		//intialize report
		reportElement.initialize();
		try {
			monitor.beginTask("", 3); //$NON-NLS-1$             

			//generate dom    			
	        monitor.worked(1);
	        reportElement.generate();
	           
        	monitor.worked(1);				
			//Get root report file
			IFile reportFile = getReportFile();
			reportFile.getProject()
					.refreshLocal(IResource.DEPTH_INFINITE, null);

			// opens the document in a view

			monitor.worked(1);

			return reportFile;
		} finally {
			try {
				monitor.done();
			} catch (Throwable e) {
				throw new Exception(Messages.OUTPUT_STREAM_ERROR_);
			}
		}
	}
}
