/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BIRTTemplateReportWizard.java,v 1.4 2008/04/10 14:53:39 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.tptp.platform.report.birt.ui.internal;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tptp.platform.common.ui.wizard.LocationPage;



public abstract class BIRTTemplateReportWizard extends BIRTReportsWizard {

    protected LocationPage locationPage;
	BIRTTemplateSelectionPage templateSelectionPage;
	protected void addReportPages() throws Exception {
        addPage(locationPage);
        addPage(templateSelectionPage);
	}

	protected void initPages(){
        locationPage = new LocationPage("location", adjustLocation()); //$NON-NLS-1$
        locationPage.setTitle(Messages._0);
        locationPage.setDescription(Messages._1);
        locationPage.setFileExtension("html"); //$NON-NLS-1$
		templateSelectionPage = new BIRTTemplateSelectionPage(Messages._3);
		templateSelectionPage.setTitle(Messages._4);
		templateSelectionPage.setDescription(Messages._5);
		
	}
	protected InputStream getReportTemplate() {
		try {
			return new FileInputStream(templateSelectionPage.templateFile.getText());
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return null;
	}
	
    protected IStructuredSelection adjustLocation() {
        IStructuredSelection structuredSelection = getSelection();
        Object selection = structuredSelection.getFirstElement();
        if (selection instanceof IResource) {
            IResource res = (IResource) selection;
            IContainer parent = res.getParent();
            if ((parent != null) && parent.exists()) {
                structuredSelection = new StructuredSelection(parent);
            }
        }
        return structuredSelection;
    }
	
	

}
