/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BIRTTemplateSelectionPage.java,v 1.2 2006/03/07 21:36:08 sleeloy Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.report.birt.ui.internal;

import java.io.File;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class BIRTTemplateSelectionPage extends WizardPage {

	Text templateFile;
	public BIRTTemplateSelectionPage(String pageName, String title, ImageDescriptor titleImage) {
		super(pageName, title, titleImage);
	}

	public BIRTTemplateSelectionPage(String pageName) {
		super(pageName);
	}

	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 3;
		GridData data = new GridData();

		Label label = new Label(container, SWT.NULL);
		label.setText(Messages._6);
		label.setLayoutData(data);

		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalAlignment = GridData.FILL;

		templateFile = new Text(container, SWT.BORDER);
		templateFile.setLayoutData(data);
		setPageComplete(false);
		templateFile.addModifyListener(new ModifyListener() {

			public void modifyText(ModifyEvent e) {
				varifyFileLocation();
			}

		});

		Button browseFolderButton = new Button(container, SWT.NONE);
		data = new GridData();
		browseFolderButton.setLayoutData(data);
		browseFolderButton.setText("Browse..."); //$NON-NLS-1$
		browseFolderButton.addSelectionListener(new SelectionAdapter() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e) {
				FileDialog dialog = new FileDialog(PlatformUI.getWorkbench()
						.getDisplay().getActiveShell(), SWT.SAVE);
				dialog
						.setFilterExtensions(new String[] { "*.rptdesign", //$NON-NLS-1$
								"*.*" }); //$NON-NLS-1$
				if (templateFile.getText() != null
						&& templateFile.getText().trim().length() > 0) {
					dialog.setFilterPath(templateFile.getText());
				}

				String selectedLocation = dialog.open();
				if (selectedLocation != null) {
					templateFile.setText(selectedLocation);
				}
			}
		});

		setControl(container);
	}
	
	protected void varifyFileLocation(){
		if ( templateFile.getText( ).trim( ).length( ) > 0 )
		{
			File f = new File( templateFile.getText( ).trim( ) );
			if ( !f.exists( ) )
			{
				setMessage( "File does not exist", ERROR ); //$NON-NLS-1$
				setPageComplete( false );
			}
			else{
				setMessage(getDescription());
				setPageComplete( true );
			}
		}
		else
		{
			setPageComplete( false );
			setMessage( "Empty file path", ERROR ); //$NON-NLS-1$
		}
	}

	public Text getTemplateFile() {
		return templateFile;
	}

}
