/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AgentInfo.java,v 1.1 2005/12/19 20:30:10 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.profile.server.core.internal;

/**
 * Contains Agent information that was attach in the profile attach wizard
 */
public class AgentInfo {
	
	private String _pid;
	private String _name;
	private String _type;
	
	protected AgentInfo(String pid, String name, String type)
	{
		_pid = pid;
		_name = name;
		_type = type;
	}

	/**
	 * Returns the PID of this agent
	 * @return a String, the PID
	 */
	public String pid()
	{
		return _pid;
	}

	/**
	 * Returns the name of this agent
	 * @return a String, the name
	 */
	public String name()
	{
		return _name;
	}
	
	/**
	 * Returns the type of this agent
	 * @return a String, the type
	 */	
	public String type()
	{
		return _type;
	}
}
