/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileOnServerAdapter.java,v 1.18 2010/10/13 20:18:39 mreid Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.profile.server.core.internal;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.AttachDelegate;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.core.IAgentController;
import org.eclipse.tptp.platform.execution.util.internal.AgentControllerPool;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

/**
 * @author ewchan
 */
public class ProfileOnServerAdapter {

	/*
	 * Ask the user for profiling options if there is more than one agent available for attach
	 * else migrate the profile options selected and attach to the profiler of the server process
	 */
	public static void attachToAgents(ILaunchConfigurationWorkingCopy wc, String hostname, int agentControllerPort, Object server) {
        try {

        	int status = wc.getAttribute(IProfileServerConstants.SERVER_DIALOG_STATUS, Dialog.OK);
        	String jvm_version = wc.getAttribute(IProfileServerConstants.SERVER_JVM_VERSION,IProfileServerConstants.JVM_142);
        	
        	if (status==Dialog.CANCEL) 
        	{  
        		return;
        	}
        	
        	/* get port number */
            int port = wc.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, CommonUIPlugin.getDefault().getPreferenceStore().getInt(CommonUIConstants.LOCALHOST_PORT));
        	
            /* set host and port attribute of launch configuration */
            wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, hostname);
            wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT,port);
        	
            
			/* Connect to the Agent Controller for process id and agent name to be attached to*/ 
			Node node = PDCoreUtil.profileConnect(hostname, String.valueOf(port), true);
			if (node == null)
				return;
			Enumeration processes = node.listProcesses();
			int numberOfAgent = 0;
			Map processMap = new HashMap(); //map for multiple agents under same process to attach.
			String pid="";
			String aName="";
			List piAgentList = new ArrayList();
			while (processes.hasMoreElements())
			{
				Process process = (Process)processes.nextElement();
				Enumeration agents = process.listAgents();
				
				if (agents == null)
					continue;

				while (agents.hasMoreElements())
				{
					Agent agent = (Agent)agents.nextElement();	
					if (!agent.isAttached()) {
						numberOfAgent++;
						processMap.put(process.getProcessId(), process);
						piAgentList.add(agent);
					}
						
					//save only the first agent for auto attach if a unique agent is found.
					if (numberOfAgent==1) {
						pid = process.getProcessId();
						aName = agent.getName();
					}
				}
			}		
			
			//look for TI agent(s)
			final IAgentController ac = AgentControllerPool.getInstance().getConnection(hostname, port, true);
            IAgent[] agents = ac.queryRunningAgents();
            List tiAgentList = new ArrayList();
            for (int i = 0; i < agents.length; i++)
            {
                        if (agents[i].getName().equals("org.eclipse.tptp.jvmti") && !agents[i].isMonitored())
                        {
                                    tiAgentList.add(agents[i]);
                                    if (tiAgentList.size()==1)
                                    {	
                                    	aName = agents[i].getName();
                                    	pid = String.valueOf(agents[i].getProcess().getProcessId());
                                    }
                                    
                                    String pidStr = String.valueOf(agents[i].getProcess().getProcessId());
                                    processMap.put(pidStr, agents[i].getProcess());
                        }
            }
            
			//System.out.println("ProfileOnServerAdapter.attachToAgents()>numberOfAgent="+numberOfAgent);
			//System.out.println("ProfileOnServerAdapter.attachToAgents()>tiAgentList="+tiAgentList.size());
			numberOfAgent = numberOfAgent+tiAgentList.size();

			
			/**
             * This method handles any agent started with a server process, both local and remote.
             *
			 * There are three cases to profile a server:
			 *		1)start the server in run/standard/regular mode and restart the server instance to profile mode in an Eclipse client.
			 *		2)start the server in profile mode from command line and let WTP server instance listen to server status and auto attach to profiling agent.
			 *		3)start the sever in profile mode from command line and attach with profile launch configuration in an Eclipse client that contains no WTP server instance.
			 * (1) and (2) are handled here.
			 */
			
			 /* prompt user for selection of agent if there is more than one agent is available for attach on the host */
			if (numberOfAgent>1) {
				if (processMap.size()==1 && numberOfAgent==2) { //multi agents under same process, assuming the only process is the target server process
					String collectorID="";
					
					//It should have only one collector selected when server start, so try to retrieve the collectorId.
					String collectorOptions = wc.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_COLLECTOR_AND_ANALYSIS, "");
					String[] collectors = collectorOptions.split(";");
					for (int i=0;i<collectors.length;i++) {
						int idx = collectors[i].indexOf(":");
						if (idx>0) {
							collectorID = collectors[i].substring(0, idx);
							break;
						}
					}
					
					/** case (1) **/
					//Profiler selected is a TI collector, with additional profiler under the same process.
					if (collectorID.indexOf("org.eclipse.tptp.trace.jvmti.jvmtiMechanism")!=-1 && piAgentList.size()==1) { 
						
						String attribute = "";
						//create attribute for additional profiling agent
						Agent piAgent = (Agent) piAgentList.get(0);
						attribute = piAgent.getProcess().getProcessId()+":"+piAgent.getName()+":org.eclipse.tptp.trace.ui.jvmpiMechanism:";
						
						//build attribute for the only ti collector
						IAgent tiAgent = (IAgent) tiAgentList.get(0);
						attribute = String.valueOf(tiAgent.getProcess().getProcessId())+":"+tiAgent.getName()+":"+collectorOptions+";"+attribute;
						wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, attribute);
					}
					
					/** case (2) **/
					//Server is started with no selection made and no launch configuration created (collectionID="" or null) in the profile session. 
					//Sever instance detected the status change and auto attach directly.
					//bug 301550
					else if (piAgentList.size()==1 && tiAgentList.size()==1) {
						String message = PluginMessages._2;

			            /* Create the attach diaglog, add the wizard page, and display it. */
			            ProfileOnServerWizard wizard = new ProfileOnServerWizard(wc,message);
			            if (!WorkbenchActivityHelper.allowUseOf(null, wizard)) {
			                return;
			            }
			            WizardDialog dialog = new WizardDialog(UIPlugin.getActiveWorkbenchWindow().getShell(), wizard);
			            dialog.create();
			            dialog.open();
			
			            int wizardReturnCode = dialog.getReturnCode();
			
			            /* Abort action if the user cancelled the action */
			            if (wizardReturnCode == Dialog.CANCEL) {
			                return;
			            }
					}
					else { //both are PI collector
						String attribute = "";
						
						for (int i=0;i<piAgentList.size();i++) {
							Agent piAgent = (Agent) piAgentList.get(i);
							if (piAgent.getName().indexOf("Java Profiling Agent") !=-1) {
								attribute = piAgent.getProcess().getProcessId()+":"+piAgent.getName()+":"+collectorOptions+";"+attribute;
							}
							else {
								//create attribute for additional profiling agent
								attribute = piAgent.getProcess().getProcessId()+":"+piAgent.getName()+":org.eclipse.tptp.trace.ui.jvmpiMechanism: ;"+attribute;
							}
						}
						
						//remove the last separator char.
						attribute = attribute.substring(0, attribute.length()-1);
											
						wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, attribute);
					}
					
				}
				else { 	//multiple agents under multiple processes, need user input
					String message = PluginMessages._2;
					if (numberOfAgent>1)
						message = PluginMessages._1;
						
		            /* Create the attach diaglog, add the wizard page, and display it. */
		            ProfileOnServerWizard wizard = new ProfileOnServerWizard(wc,message);
		            if (!WorkbenchActivityHelper.allowUseOf(null, wizard)) {
		                return;
		            }
		            WizardDialog dialog = new WizardDialog(UIPlugin.getActiveWorkbenchWindow().getShell(), wizard);
		            dialog.create();
		            dialog.open();
		
		            int wizardReturnCode = dialog.getReturnCode();
		
		            /* Abort action if the user cancelled the action */
		            if (wizardReturnCode == Dialog.CANCEL) {
		                return;
		            }
				}
			}
			else if (numberOfAgent==1) { 
					/* auto attach with options previously selected when before server was started 
					   migrate launch configuration attribute to attach launcher
					   from IProfileLaunchConfigurationConstants.ATTR_PROFILING_COLLECTOR_AND_ANALYSIS="DATA_COLLECTOR_ID_1:ANALYSIS_TYPE_ID_1,ANALYSIS_TYPE_ID_2;DATA_COLLECTOR_ID_2:ANALYSIS_TYPE_ID1,ANALYSIS_TYPE_ID2..."
					   to   IProfileLaunchConfigurationConstants.ATTR_AGENTS="pid1:agentName1:dataCollectorId1:analysisTypeID1,analysisTypeID2;pid2:agentName1:dataCollectorId1:analysisTypeID1..." */
					String attribute = wc.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_COLLECTOR_AND_ANALYSIS, "");
					if (!attribute.equals("")) {
						attribute = pid+":"+aName+":"+attribute;  //$NON-NLS-1$ //$NON-NLS-2$
						wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, attribute);
					}
					else {						
						/** case (2) **/
						//Server is started with no selection made and no launch configuration created in the profile session. 
						//Sever instance detected the status change and auto attach directly.
						//bug 301550
						String message = PluginMessages._2;
							
			            /* Create the attach diaglog, add the wizard page, and display it. */
			            ProfileOnServerWizard wizard = new ProfileOnServerWizard(wc,message);
			            if (!WorkbenchActivityHelper.allowUseOf(null, wizard)) {
			                return;
			            }
			            WizardDialog dialog = new WizardDialog(UIPlugin.getActiveWorkbenchWindow().getShell(), wizard);
			            dialog.create();
			            dialog.open();
			
			            int wizardReturnCode = dialog.getReturnCode();
			
			            /* Abort action if the user cancelled the action */
			            if (wizardReturnCode == Dialog.CANCEL) {
			                return;
			            }
					}
			
			}
			
			if (numberOfAgent!=0) {
				/* attach to process */
	            AttachDelegate delegate = new AttachDelegate();
	            delegate.launch(wc, ILaunchManager.PROFILE_MODE, null, new NullProgressMonitor());
			}
        } catch (Exception e) {
            ServerPlugin.log(IStatus.ERROR, e);
        }
    }
}