/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileOnServerWizard.java,v 1.2 2007/04/23 18:11:21 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.profile.server.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbench;

public class ProfileOnServerWizard extends Wizard implements IPluginContribution {

	private ProfileOnServerWizardPage _page;
	private ILaunchConfigurationWorkingCopy _wc;
	private String _message;
	
	public ProfileOnServerWizard(ILaunchConfigurationWorkingCopy workingCopy,String message) {
		super();
		_wc = workingCopy;
		_message = message;
		
	}

	/*
	 * @see org.eclipse.ui.IPluginContribution#getLocalId()
	 */
	public String getLocalId() {
		return " org.eclipse.tptp.platform.profile.server.core.internal.ProfileOnServerWizard"; //$NON-NLS-1$
	}
	
	/*
	 * @see org.eclipse.ui.IPluginContribution#getPluginId()
	 */
	public String getPluginId() {
		return ServerPlugin.getDefault().getBundle().getSymbolicName();
	}
	
	public void addPages() {
		setWindowTitle(PluginMessages.STR_PROFILE_SERVER_TITLE);  //$NON-NLS-1$
		_page = new ProfileOnServerWizardPage("org.eclipse.tptp.platform.profile.server.core.internal.ProfileOnServerWizardPage", _wc, _message); //$NON-NLS-1$
		addPage(_page);
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		setDefaultPageImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_ATTACH));
	}

	public boolean performFinish() {
		boolean result = _page.finish();
		try {
			_wc.doSave();
		}
		catch (CoreException e) {
            ServerPlugin.log(IStatus.ERROR, e);
		}
		return result;
	}
}
