/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileOnServerWizardPage0.java,v 1.1 2005/12/19 20:30:10 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.profile.server.core.internal;

import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

/**
 * @author qiyanli
 *
 */
public class ProfileOnServerWizardPage0 extends WizardPage {

    private ILaunchConfigurationWorkingCopy workingCopy;

    /**
     * Constructor of the wizard page. Expects the name of this wizard page as well as
     * a working copy of the ILaunchConfiguration of the server that was just started.
     * 
     * @param name name of this wizard page.
     * @param wc a working copy of the ILaunchConfiguration of the server that was just started.
     */
    public ProfileOnServerWizardPage0(String name, ILaunchConfigurationWorkingCopy workingCopy) {
        super(name);
        this.workingCopy = workingCopy;
        setTitle(PluginMessages.STR_PROFILE_SERVER_TITLE);
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
     */
    public void createControl(Composite parent) {

        Composite content = new Composite(parent, SWT.NONE);
    }

}
