/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ServerPlugin.java,v 1.2 2007/04/23 17:59:28 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.profile.server.core.internal;

import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * This is for plug-in life cycle management with some utilities.
 */
public class ServerPlugin extends AbstractUIPlugin {
	private static final String PLUGIN_ID = "org.eclipse.tptp.platform.profile.server.core";  
    /**
     * The shared plugin instance
     */
    private static ServerPlugin plugin;

    /**
     * The constructor.
     */
    public ServerPlugin() {
        plugin = this;
    }

    /**
     * This method is called when the plug-in is stopped
     */
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    /**
     * Returns the shared instance.
     */
    public static ServerPlugin getDefault() {
        return plugin;
    }

    /**
     * Logs a message in the workspace log file with the given severity.
     * 
     * @param severity The severity of the error or exception
     * @param throwable The error or exception
     */
    public static void log(int severity, Throwable throwable) {
        Status status = new Status(severity, plugin.getBundle().getSymbolicName(), 0, throwable.toString(), throwable);
        plugin.getLog().log(status);
    }
    
	public static void logError(Throwable throwable) {
		Status status = new Status(Status.ERROR, plugin.getBundle().getSymbolicName(), 0, throwable.toString(), throwable);
		plugin.getLog().log(status);
	}
	
	public static String getPluginId() {
		return PLUGIN_ID;
	}
}
