/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.profile.server.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.tptp.trace.ui.provisional.launcher.ICollectorFiltration;

/**
 * This filtration class is used to filter the JVMTI data collector if the
 * targeted host uses JRE 1.4 or older.
 *  
 * @author Ali Mehregani
 * @author Eugene Chan
 */
public class TICollectorFiltration implements ICollectorFiltration
{

	public boolean include(String id, ILaunchConfiguration configuration, Object context)
	{
		try {
			String jvm_version = configuration.getWorkingCopy().getAttribute(IProfileServerConstants.SERVER_JVM_VERSION,IProfileServerConstants.JVM_5);
			return (jvm_version.equals(IProfileServerConstants.JVM_5) || jvm_version.equals(IProfileServerConstants.JVM_6));
		} catch (CoreException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return true;
	}
}
