/**********************************************************************
 * Copyright (c) 2006, 2010 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.integration.pde.internal.delegators;

import java.io.File;
import java.util.ArrayList;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.pde.ui.launcher.EquinoxLaunchConfiguration;
import org.eclipse.tptp.platform.integration.pde.internal.util.PDEIntegrationLauncherUtility;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherConstants;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.AbstractProcessLauncher;

public abstract class AbstractEquinoxDelegate extends AbstractProcessLauncher
{
	/** Used to extract specific attributes from the configuration */
	protected EquinoxLaunchConfigurationExtended equinoxLaunchConfiguration;
	
	public AbstractEquinoxDelegate(String agentName, String agentType)
	{
		super(agentName, agentType);	
		equinoxLaunchConfiguration = new EquinoxLaunchConfigurationExtended();
	}

	
	public void preLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException
	{
		equinoxLaunchConfiguration.preLaunchCheck(configuration, launch, new SubProgressMonitor(monitor, 2));
		equinoxLaunchConfiguration.setConfigurationDirectory(null);		

		equinoxLaunchConfiguration.synchronizeManifests(configuration, new SubProgressMonitor(monitor, 1));
		equinoxLaunchConfiguration.manageLaunch(launch);
		super.preLaunch(configuration, mode, launch, monitor);
	}	 
	
	protected String getWorkingDirectory(ILaunchConfiguration conf)
	{
		return null;
	}

	protected String getProgramArguments(ILaunchConfiguration conf)
	{
		try
		{
			return LauncherUtility.convertToString(equinoxLaunchConfiguration.getProgramArguments(conf));
		} catch (CoreException e)
		{			
			e.printStackTrace();
			return null;
		}
	}

	protected String getMainTypeName(ILaunchConfiguration conf)
	{
		return LauncherConstants.ECLIPSE_MAIN;
	}

	protected String getVMArguments(ILaunchConfiguration conf)
	{
		try
		{
			return LauncherUtility.convertToString(new ExecutionArguments(conf.getAttribute("org.eclipse.jdt.launching.VM_ARGUMENTS",""),"").getVMArgumentsArray());
		} catch (CoreException e)
		{
			e.printStackTrace();
			return null;
		}
	}

	protected String[] getClasspath(ILaunchConfiguration conf)
	{
		try
		{
			return equinoxLaunchConfiguration.getClasspath(conf);
		} catch (CoreException e)
		{
			e.printStackTrace();
			return null;
		}
	}

	
	private class EquinoxLaunchConfigurationExtended extends EquinoxLaunchConfiguration
	{
		public void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
			super.preLaunchCheck(configuration, launch, monitor);
		}

		public void setConfigurationDirectory(File directory)
		{
			fConfigDir = directory;
		}
		
		public File getConfigDir(ILaunchConfiguration configuration) 
		{
			return super.getConfigDir(configuration);
		}
		
		public void manageLaunch(ILaunch launch) {
			super.manageLaunch(launch);
		}
		
		public void synchronizeManifests(ILaunchConfiguration configuration,
			IProgressMonitor monitor) {
			super.synchronizeManifests(configuration, monitor);
		}
	}

	protected ArrayList getLaunchTypeWorkspaceFilters(final ILaunchConfiguration config) throws CoreException {
		// additional criteria for OSGi bindles distinguishing might be applied here
		return PDEIntegrationLauncherUtility.getWorkspacePluginFilters(config, LauncherUtility.getActiveWorkingSets());
	}
}
