/**********************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.integration.pde.internal.delegators;

import java.io.File;
import java.util.ArrayList;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileLaunchUtil;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.tptp.platform.integration.pde.internal.util.PDEIntegrationLauncherUtility;
import org.eclipse.tptp.platform.integration.pde.internal.util.PDEIntegrationLauncherUtility.JUnitPluginConfigurationExtended;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.AbstractProcessLauncher;


public abstract class AbstractJUnitPluginDelegate extends AbstractProcessLauncher
{
	/** 
	 * Used to extract attributes from configuraiton 
	 */
	protected JUnitPluginConfigurationExtended junitConfiguration;
	
	public AbstractJUnitPluginDelegate(String agentName, String agentType)
	{
		super(agentName, agentType);
		junitConfiguration = new JUnitPluginConfigurationExtended();
	}
	
	public void preLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException
	{		
		junitConfiguration.launch(configuration, mode, launch, monitor);
		super.preLaunch(configuration, mode, launch, monitor);
	}
	
	protected String getWorkingDirectory(ILaunchConfiguration conf)
	{
		return junitConfiguration.getVMRunnerConfiguration().getWorkingDirectory();
	}

	protected String getProgramArguments(ILaunchConfiguration conf)
	{
		return ProfileLaunchUtil.convertToDelimitedString(junitConfiguration.getVMRunnerConfiguration().getProgramArguments(), ' ');
	}

	protected String getMainTypeName(ILaunchConfiguration conf)
	{
		return junitConfiguration.getVMRunnerConfiguration().getClassToLaunch();
	}

	protected String getVMArguments(ILaunchConfiguration conf)
	{
		return ProfileLaunchUtil.convertToDelimitedString(junitConfiguration.getVMRunnerConfiguration().getVMArguments(), ' ');
	}

	protected String[] getClasspath(ILaunchConfiguration conf)
	{	
		return null;
	}
	
	protected String getClasspathString(ILaunchConfiguration conf) throws CoreException 
	{
		return ProfileLaunchUtil.convertToDelimitedString(junitConfiguration.getVMRunnerConfiguration().getClassPath(), File.pathSeparatorChar, false);
	}

	protected ArrayList getLaunchTypeWorkspaceFilters(final ILaunchConfiguration config) throws CoreException {
		ArrayList result = super.getLaunchTypeWorkspaceFilters(config);
		result.add(new FilterTableElement("junit*", "*", TraceMessages.INCLUDE));

		ArrayList workspacePluginFilters = PDEIntegrationLauncherUtility.getWorkspacePluginFilters(config, LauncherUtility.getActiveWorkingSets());
		result.addAll(workspacePluginFilters);
		return result;
	}
}
