/**********************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.integration.pde.internal.delegators;

import java.io.File;
import java.util.ArrayList;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.pde.ui.launcher.EclipseApplicationLaunchConfiguration;
import org.eclipse.pde.ui.launcher.IPDELauncherConstants;
import org.eclipse.tptp.platform.integration.pde.internal.util.PDEIntegrationLauncherUtility;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherConstants;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.AbstractProcessLauncher;

public abstract class AbstractRuntimeWorkbenchDelegate extends
		AbstractProcessLauncher
{	
	/** Used to extract specific values from the configuration */
	protected EclipseConfigurationExtended runtimeConfiguration;
	
	public AbstractRuntimeWorkbenchDelegate(String agentName, String agentType)
	{
		super(agentName, agentType);
		runtimeConfiguration = new EclipseConfigurationExtended();
	}

	public void preLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException
	{
		runtimeConfiguration.setConfigurationDirectory(null);
		
		runtimeConfiguration.promptToClear(configuration, monitor);
		launch.setAttribute(IPDELauncherConstants.CONFIG_LOCATION, runtimeConfiguration.getConfigDir(configuration).toString());
		runtimeConfiguration.preLaunchCheck(configuration, launch, monitor);
		super.preLaunch(configuration, mode, launch, monitor);
	}
	
	protected String getWorkingDirectory(ILaunchConfiguration conf)
	{		
		return null;
	}

	protected String getProgramArguments(ILaunchConfiguration conf)
	{
		try
		{
			return LauncherUtility.convertToString(runtimeConfiguration.getProgramArguments(conf));
		} 
		catch (CoreException e)
		{
			e.printStackTrace();
			return null;
		}
	}

	protected String getMainTypeName(ILaunchConfiguration conf)
	{
		return LauncherConstants.ECLIPSE_MAIN;
	}

	protected String getVMArguments(ILaunchConfiguration conf)
	{
		try
		{
			String[] args = runtimeConfiguration.getVMArguments(conf);
			return LauncherUtility.convertToString(args);
		} catch (CoreException e)
		{
			e.printStackTrace();
			return null;
		}
	}

	protected String[] getClasspath(ILaunchConfiguration conf)
	{
		try
		{
			return runtimeConfiguration.getClasspath(conf);
		} catch (CoreException e)
		{
			e.printStackTrace();
			return null;
		}
	}
	
	private class EclipseConfigurationExtended extends EclipseApplicationLaunchConfiguration
	{
		public void setConfigurationDirectory(File directory)
		{
			fConfigDir = directory;
		}
		
		public File getConfigDir(ILaunchConfiguration configuration) 
		{
			return super.getConfigDir(configuration);
		}
		
				
		public void promptToClear(ILaunchConfiguration configuration,
			IProgressMonitor monitor) throws CoreException {
			super.clear(configuration, monitor);
		}

		public void preLaunchCheck(ILaunchConfiguration configuration,
				ILaunch launch, IProgressMonitor monitor) throws CoreException {
			super.preLaunchCheck(configuration, launch, monitor);
		}
		
	}

	protected ArrayList getLaunchTypeWorkspaceFilters(final ILaunchConfiguration config) throws CoreException {
		return PDEIntegrationLauncherUtility.getWorkspacePluginFilters(config, LauncherUtility.getActiveWorkingSets());
	}
}
