/**********************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.integration.pde.internal.delegators;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.tptp.trace.ui.internal.launcher.deleg.application.AgentDiscovererDelegateHelper;
import org.eclipse.tptp.trace.ui.internal.launcher.deleg.application.AgentDiscovererDelegateHelper.DummyAgent;
import org.eclipse.tptp.trace.ui.internal.launcher.deleg.application.AgentDiscovererDelegateHelper.DynamicAgentDiscoverer;
import org.eclipse.tptp.trace.ui.internal.launcher.deleg.application.AgentDiscovererDelegateHelper.ILoggingAgentDiscovererDelegate;

public class AgentDiscovererEquinoxDelegate extends AbstractEquinoxDelegate implements ILoggingAgentDiscovererDelegate
{
	/* The process bounded to the agent discoverer */
	private Process process;	
	
	/* The dynamic agent discoverer */
	private DynamicAgentDiscoverer dynamicAgentDiscoverer;
	
	public AgentDiscovererEquinoxDelegate()
	{
		super (AgentDiscovererDelegateHelper.LAD_NAME, AgentDiscovererDelegateHelper.LAD_TYPE);
	}
		
	public Process createProcess()
	{
		return AgentDiscovererDelegateHelper.createProcess(node);
	}
	
	 
	public Agent createAgent(Process process, final TRCProcessProxy trcProcessProxy) throws CoreException
	{	
		this.process = process;
		dynamicAgentDiscoverer = new DynamicAgentDiscoverer(conf, process, trcProcessProxy);
		AgentDiscovererDelegateHelper.registerProcessListener(process, trcProcessProxy, dynamicAgentDiscoverer, this);
		return null;
	}
	
	
	public void activateAgent(TRCProcessProxy processProxy)
	{			
		TRCAgentProxy agentProxy = PDCoreUtil.createAgent(processProxy, new DummyAgent(process));		
		dynamicAgentDiscoverer.setAgentProxy(agentProxy);
		AgentDiscovererDelegateHelper.activateAgent(processProxy, agentProxy);
	}

}
