/**********************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.integration.pde.internal.delegators;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.internal.piclient.PIProcessListener;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.tptp.trace.ui.internal.launcher.deleg.application.PIDelegateHelper;
import org.eclipse.tptp.trace.ui.provisional.launcher.ProcessParameters;

public class PIRuntimeWorkbenchLauncherDelegate extends AbstractRuntimeWorkbenchDelegate
{
	/* Acts as both a process and an agent listener */
	private PIProcessListener listener;
	
	public PIRuntimeWorkbenchLauncherDelegate()
	{
		super(CommonUIConstants.PROFILE_AGENT_NAME, CommonUIConstants.PROFILE_AGENT_TYPE);
	}
	
	
	public Agent createAgent(Process process, TRCProcessProxy trcProcessProxy) throws CoreException
	{		
		return PIDelegateHelper.createAgent(conf, process, trcProcessProxy, getAgentName(), getAgentType(), getProfileFile(), listener);
	}
	
	/**
	 * We need to add the PI flags	  
	 */
	public ProcessParameters getProcessParameters(ILaunchConfiguration launchConfiguration)
	{
		return PIDelegateHelper.getProcessParameter(super.getProcessParameters(launchConfiguration), conf);
	}	
	
	public void configureProcess(Process process, TRCProcessProxy trcProcessProxy) throws CoreException
	{	
		super.configureProcess(process, trcProcessProxy);
		listener = PIDelegateHelper.configureProcess(process, trcProcessProxy, conf, getClassPath());
	}
}
