/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileEquinoxLauncherTabGroup.java,v 1.2 2010/08/22 22:10:19 jwest Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.integration.pde.internal.shortcuts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.EnvironmentTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.sourcelookup.SourceLookupTab;
import org.eclipse.hyades.trace.ui.internal.launcher.DestinationTab;
import org.eclipse.hyades.trace.ui.internal.launcher.HyadesTraceUIExtensionSupportUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileExtendedTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaArgumentsTab;
import org.eclipse.pde.ui.launcher.BundlesTab;
import org.eclipse.pde.ui.launcher.OSGiLauncherTabGroup;
import org.eclipse.pde.ui.launcher.OSGiSettingsTab;
import org.eclipse.pde.ui.launcher.TracingTab;

public class ProfileEquinoxLauncherTabGroup extends OSGiLauncherTabGroup{

	public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
		ILaunchConfigurationTab[] tabs;
		tabs = new ILaunchConfigurationTab[]{
				new BundlesTab(),
				new ProfileExtendedTab(false),
				new DestinationTab(),
				new JavaArgumentsTab(),
				new OSGiSettingsTab(),
				new TracingTab(), 
				new EnvironmentTab(),
				new SourceLookupTab(), 
				new CommonTab()};

		List<ILaunchConfigurationTab> result = new ArrayList<ILaunchConfigurationTab>();
		for(ILaunchConfigurationTab t: tabs) {
			result.add(t);
		}
		
		// Provide profiling dialogue tab list to interested extensions (Bug 323330)
		HyadesTraceUIExtensionSupportUtil.addOrInformExtensionTabs(result, ProfileEquinoxLauncherTabGroup.class);
		
		ILaunchConfigurationTab[] array = new ILaunchConfigurationTab[result.size()];
		result.toArray(array);
		
		setTabs(array);
		

	}
}
