/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileJUnitPluginShortcut.java,v 1.1 2007/04/19 20:19:40 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.integration.pde.internal.shortcuts;

import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.launcher.RunLaunchProfileStatusHandler;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.Window;
import org.eclipse.pde.ui.launcher.JUnitWorkbenchLaunchShortcut;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.integration.pde.internal.PDEIntegrationMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherConstants;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;


public class ProfileJUnitPluginShortcut extends JUnitWorkbenchLaunchShortcut 
{

	/*
	 * @see org.eclipse.jdt.internal.junit.launcher.JUnitLaunchShortcut#launchConfiguration(java.lang.String, org.eclipse.debug.core.ILaunchConfiguration)
	 */
	protected void launchConfiguration(final String mode, final ILaunchConfiguration conf) {
		Display.getDefault().asyncExec(new Runnable() {
			public void run() {
				Shell shell = UIPlugin.getActiveWorkbenchShell();
				int result = DebugUITools.openLaunchConfigurationPropertiesDialog(shell, conf, IDebugUIConstants.ID_PROFILE_LAUNCH_GROUP, new Status(Status.OK, UIPlugin.getPluginId(), RunLaunchProfileStatusHandler.CODE, "", null));
				if (result == Window.OK) {
					DebugUITools.launch(conf, mode);
				}
			}
		});
	}
	
	/**
	 * Prompts the user to select a type
	 * 
	 * @return the selected type or <code>null</code> if none.
	 */
	protected IType chooseType(IType[] types, String mode) throws InterruptedException {
		if (mode.equals(ILaunchManager.PROFILE_MODE)) {
			ElementListSelectionDialog dialog= new ElementListSelectionDialog(UIPlugin.getActiveWorkbenchShell(), new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_POST_QUALIFIED));
			dialog.setElements(types);
			dialog.setTitle(TraceMessages.LNC_SHSTT); 
			dialog.setMessage(TraceMessages.LNC_SHSTM); 
			dialog.setMultipleSelection(false);
			if (dialog.open() == Window.OK) {
				return (IType)dialog.getFirstResult();
			}
			return null;
		}
		else {
			ElementListSelectionDialog dialog= new ElementListSelectionDialog(UIPlugin.getActiveWorkbenchShell(), new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_POST_QUALIFIED));
			dialog.setElements(types);
			dialog.setTitle(PDEIntegrationMessages.JUnitLaunchShortcut_dialog_title2);
			if (mode.equals(ILaunchManager.DEBUG_MODE)) {
				dialog.setMessage(PDEIntegrationMessages.JUnitLaunchShortcut_message_selectTestToDebug);
			} else {
				dialog.setMessage(PDEIntegrationMessages.JUnitLaunchShortcut_message_selectTestToRun);
			}
			dialog.setMultipleSelection(false);
			if (dialog.open() == Window.OK) {
				return (IType) dialog.getFirstResult();
			}
			throw new InterruptedException(); // cancelled by user
		}
	}

	/**
	 * Show a selection dialog that allows the user to choose one of the specified
	 * launch configurations.  Return the chosen config, or <code>null</code> if the
	 * user cancelled the dialog.
	 * @throws LaunchCancelledByUserException 
	 */
	protected ILaunchConfiguration chooseConfiguration(List configList, String mode) throws InterruptedException {
		if (mode.equals(ILaunchManager.PROFILE_MODE)) {
			IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
			ElementListSelectionDialog dialog= new ElementListSelectionDialog(UIPlugin.getActiveWorkbenchShell(), labelProvider);
			dialog.setElements(configList.toArray());
			dialog.setTitle(TraceMessages.LSH_SCFT); 
			dialog.setMessage(TraceMessages.LSH_SCFM); 
			dialog.setMultipleSelection(false);
			int result= dialog.open();
			labelProvider.dispose();
			if (result == ElementListSelectionDialog.OK) {
				return (ILaunchConfiguration)dialog.getFirstResult();
			}
			
			throw new InterruptedException();
		}
		else {
			IDebugModelPresentation labelProvider= DebugUITools.newDebugModelPresentation();
			ElementListSelectionDialog dialog= new ElementListSelectionDialog(UIPlugin.getActiveWorkbenchShell(), labelProvider);
			dialog.setElements(configList.toArray());
			dialog.setTitle(PDEIntegrationMessages.JUnitLaunchShortcut_message_selectConfiguration);
			if (mode.equals(ILaunchManager.DEBUG_MODE)) {
				dialog.setMessage(PDEIntegrationMessages.JUnitLaunchShortcut_message_selectDebugConfiguration);
			} else {
				dialog.setMessage(PDEIntegrationMessages.JUnitLaunchShortcut_message_selectRunConfiguration);
			}
			dialog.setMultipleSelection(false);
			int result= dialog.open();
			if (result == Window.OK) {
				return (ILaunchConfiguration) dialog.getFirstResult();
			}
			throw new InterruptedException(); // cancelled by user
		}
	}
	
	protected ILaunchConfigurationWorkingCopy createLaunchConfiguration(IJavaElement element) throws CoreException
	{
		ILaunchConfigurationWorkingCopy configuration = super.createLaunchConfiguration(element);
		ProfilingSetsManager manager = ProfilingSetsManager.instance();
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		boolean autoFilteringCriteriaDefault = store.getBoolean(TraceConstants.AUTO_FILTER_CRITERIA_OPTION);
		configuration.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_FILTER_CRITERIA, autoFilteringCriteriaDefault);
		configuration.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, manager.getDefaultSet() == null ? null : manager.getDefaultSet().getId());
		configuration.setAttribute(IProfileLaunchConfigurationConstants.ATTR_FILTER_SET, autoFilteringCriteriaDefault ? TraceConstants.AUTO_GENERATED_FILTER_SET : LauncherConstants.DEFAULT_FILTER_ID);
		return configuration;
	}
}
