/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileJUnitPluginTabGroup.java,v 1.2 2010/08/22 22:10:19 jwest Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.integration.pde.internal.shortcuts;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.EnvironmentTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.hyades.trace.ui.internal.launcher.DestinationTab;
import org.eclipse.hyades.trace.ui.internal.launcher.HyadesTraceUIExtensionSupportUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileExtendedTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaArgumentsTab;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationTab;
import org.eclipse.pde.ui.launcher.ConfigurationTab;
import org.eclipse.pde.ui.launcher.JUnitTabGroup;
import org.eclipse.pde.ui.launcher.PluginJUnitMainTab;
import org.eclipse.pde.ui.launcher.PluginsTab;
import org.eclipse.pde.ui.launcher.TracingTab;

/*
 * NOTE: This class uses functionality that is internal to the PDE.
 * As soon as this functionality is made public, this class should
 * be modified accordingly. 
 */
public class ProfileJUnitPluginTabGroup extends JUnitTabGroup
{
	public void createTabs(ILaunchConfigurationDialog dialog, String mode)
	{
		
		ILaunchConfigurationTab[] tabs = null;
		tabs = new ILaunchConfigurationTab[]{
				new JUnitLaunchConfigurationTab(),
				new ProfileExtendedTab(false),
				new DestinationTab(),
				new PluginJUnitMainTab(), 
				new JavaArgumentsTab(),
				new PluginsTab(false),	
				new ConfigurationTab(true), 
				new TracingTab(),
				new EnvironmentTab(), 
				new CommonTab()};

		List<ILaunchConfigurationTab> result = new ArrayList<ILaunchConfigurationTab>();
		for(ILaunchConfigurationTab t: tabs) {
			result.add(t);
		}

		// Provide profiling dialogue tab list to interested extensions (Bug 323330)
		HyadesTraceUIExtensionSupportUtil.addOrInformExtensionTabs(result, ProfileJUnitPluginTabGroup.class);

		ILaunchConfigurationTab[] array = new ILaunchConfigurationTab[result.size()];
		result.toArray(array);
		
		setTabs(array);
		
	}
}

