/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileRuntimeWorkbenchShortcut.java,v 1.1 2007/04/19 20:19:40 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.integration.pde.internal.shortcuts;

import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.RunLaunchProfileStatusHandler;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jface.window.Window;
import org.eclipse.pde.ui.launcher.EclipseLaunchShortcut;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ProfileRuntimeWorkbenchShortcut extends EclipseLaunchShortcut {

	protected void launch(final String mode) {
		final ILaunchConfiguration config = findLaunchConfiguration(mode);
		if (config != null) {
			Display.getDefault().asyncExec(new Runnable() {
				public void run() {
					Shell shell = UIPlugin.getActiveWorkbenchShell();
					int result = DebugUITools.openLaunchConfigurationPropertiesDialog(shell, config, IDebugUIConstants.ID_PROFILE_LAUNCH_GROUP, new Status(Status.OK, UIPlugin.getPluginId(), RunLaunchProfileStatusHandler.CODE, "", null));
					if (result == Window.OK) {
						DebugUITools.launch(config, mode);
					}
				}
			});
		}
	}

	/**
	 * Shows a selection dialog that allows the user to choose one of the specified
	 * launch configurations.  Return the chosen config, or <code>null</code> if the
	 * user cancelled the dialog.
	 */
	protected ILaunchConfiguration chooseConfiguration(ILaunchConfiguration[] configs, String mode) {
		if (mode.equals(ILaunchManager.PROFILE_MODE)) {
			IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
			ElementListSelectionDialog dialog = new ElementListSelectionDialog(UIPlugin.getActiveWorkbenchShell(), labelProvider);
			dialog.setElements(configs);
			dialog.setTitle(TraceMessages.LSH_SCFT);  
			dialog.setMessage(TraceMessages.LSH_SCFM);  
			dialog.setMultipleSelection(false);
			int result = dialog.open();
			labelProvider.dispose();
			if (result == ElementListSelectionDialog.OK) {
				return (ILaunchConfiguration)dialog.getFirstResult();
			}
			return null;
		}
		else {
			return super.chooseConfiguration(configs, mode);
		}
	}

}
