/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileRuntimeWorkbenchTabGroup.java,v 1.2 2010/08/22 22:10:19 jwest Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.integration.pde.internal.shortcuts;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.EnvironmentTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.hyades.trace.ui.internal.launcher.DestinationTab;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileExtendedTab;
import org.eclipse.hyades.trace.ui.internal.launcher.HyadesTraceUIExtensionSupportUtil;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaArgumentsTab;
import org.eclipse.pde.ui.launcher.ConfigurationTab;
import org.eclipse.pde.ui.launcher.EclipseLauncherTabGroup;
import org.eclipse.pde.ui.launcher.MainTab;
import org.eclipse.pde.ui.launcher.PluginsTab;
import org.eclipse.pde.ui.launcher.TracingTab;

public class ProfileRuntimeWorkbenchTabGroup extends EclipseLauncherTabGroup
{
	public void createTabs(ILaunchConfigurationDialog dialog, String mode)
	{
		
		List<ILaunchConfigurationTab> tabs = new ArrayList<ILaunchConfigurationTab>();
		
		tabs.add(new MainTab());
		tabs.add(new ProfileExtendedTab(false));
		tabs.add(new DestinationTab());
		tabs.add(new JavaArgumentsTab());
		tabs.add(new PluginsTab()); 
		tabs.add(new ConfigurationTab());
		tabs.add(new TracingTab()); 
		tabs.add(new EnvironmentTab());
		tabs.add(new CommonTab());
		
		// Provide profiling dialogue tab list to interested extensions (Bug 323330)
		HyadesTraceUIExtensionSupportUtil.addOrInformExtensionTabs(tabs, ProfileRuntimeWorkbenchTabGroup.class);

		ILaunchConfigurationTab[] array = new ILaunchConfigurationTab[tabs.size()];
		tabs.toArray(array);

		setTabs(array);
	}
}

