/**********************************************************************
 Copyright (c) 2007 IBM Corporation and others.
 All rights reserved. This program and the accompanying materials
 are made available under the terms of the Eclipse Public License v1.0
 which accompanies this distribution, and is available at
 http://www.eclipse.org/legal/epl-v10.html
 $Id: ConfigGenerator.java,
 
 Contributors:
     IBM - initial implementation
 **********************************************************************/

package org.eclipse.hyades.probekit;

import org.eclipse.tptp.platform.agentcontroller.config.Agent;
import org.eclipse.tptp.platform.agentcontroller.config.AgentControllerEnvironment;
import org.eclipse.tptp.platform.agentcontroller.config.ConfigUtility;
import org.eclipse.tptp.platform.agentcontroller.config.Constants;
import org.eclipse.tptp.platform.agentcontroller.config.Option;
import org.eclipse.tptp.platform.agentcontroller.config.PluginConfig;
import org.eclipse.tptp.platform.agentcontroller.config.SetConfigSkeleton;
import org.eclipse.tptp.platform.agentcontroller.config.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * This class is used to generate Probekit's configuration file.  See bugzilla 184040.
 * 
 * @author Navid Mehregani
 *
 */
public class SetConfig extends SetConfigSkeleton {

	public void askUser() {
		/* Will not be used */
	}

	/**
	 * Generate Probekit's configuration file 
	 */
	public void generateConfiguration() {
	
		/* Path to plugin */
		String pluginPath = "%" + Constants.PLUGINS_HOME + "%" + sr + getPluginName();
		
		/* Path to the correct native files for the plugin */
		String nativePath = pluginPath + sr + "os"; 
		
		final String OPERATING_SYSTEM = System.getProperty("os.name").toLowerCase();
		final String SYSTEM_ARCH = System.getProperty("os.arch").toLowerCase();
		
		/* File extension of the native file (e.g. dll or so) */
		String nativeExtension = "";
		
		boolean error = false;
		
		/* Windows */
		if (OPERATING_SYSTEM.indexOf("windows") != -1)
		{
			nativeExtension = ".dll";
			
			/* Now check the system architecture */
			nativePath = nativePath + sr + "win32";
						
			/* IA32 */
			if (SYSTEM_ARCH.indexOf("x86") != -1)
				nativePath = nativePath + sr + "x86";
			
			/* Unknown architecture */
			else
				error = true;
			
		}
		/* Linux */
		else if (OPERATING_SYSTEM.indexOf("linux") != -1)
		{
			nativeExtension = ".so";
			
			nativePath = nativePath + sr + "linux";
			
			/* Now check the system architecture */		
			
			/* IA32 */
			if (SYSTEM_ARCH.indexOf("x86") != -1)
				nativePath = nativePath + sr + "x86";
			
			/* Unknown architecture */
			else
				error = true;
		}
		else
		{
			error = true;
		}
		
		/* Just return if there was an error */
		if (error)
			return;
		
		
		
		/* Standard initializer */ 
		Document doc = configFile.getDoc();
		if(doc == null) {
			return;
		}

		Element pluginConfigElement = doc.createElement(PluginConfig.TAG);
		
		/* Create PluginConfiguration element */
		PluginConfig.setRequires(pluginConfigElement,"org.eclipse.tptp.platform.collection.framework");
		
		Element holder = configFile.getHolder();
		holder.appendChild(pluginConfigElement);
		
		/* Create AgentControllerEnvironment element */
		Element acEnvironmentElement = doc.createElement(AgentControllerEnvironment.TAG);
		AgentControllerEnvironment.setConfiguration(acEnvironmentElement, "default");
		pluginConfigElement.appendChild(acEnvironmentElement);
		
		/* Create PATH variable element */
		Element pathVariableElement = doc.createElement(Variable.TAG);
		Variable.setName(pathVariableElement, "PATH");
		Variable.setPosition(pathVariableElement, "prepend");
		Variable.setValue(pathVariableElement, nativePath);
		acEnvironmentElement.appendChild(pathVariableElement);

		/* Create Agent element */
		Element agentElement = doc.createElement(Agent.TAG);
		Agent.setConfiguration(agentElement, "default");
		Agent.setName(agentElement, "Java Profiling Agent");
		agentElement.setAttribute(ConfigUtility.getString("Config.Application.Extends.Tag"), "default");
		pluginConfigElement.appendChild(agentElement);
		
		/* Create the libraryName agent option */
		Element optionElement = doc.createElement(Option.TAG);
		Option.setName(optionElement, "piAgentExtension");
		Option.setType(optionElement, "libraryName");
		Option.setValue(optionElement, nativePath + sr + "ProbeAgentExtension" + nativeExtension);
		agentElement.appendChild(optionElement);
		
		/* Create the BCILibraryName agent option */
		optionElement = doc.createElement(Option.TAG);
		Option.setName(optionElement, "ProbeAgentExtension");
		Option.setType(optionElement, "BCILibraryName");
		Option.setValue(optionElement, nativePath + sr + "BCIEngProbe" + nativeExtension);
		agentElement.appendChild(optionElement);
		
		/* Create the logFile agent option */
		optionElement = doc.createElement(Option.TAG);
		Option.setName(optionElement, "ProbeAgentExtension");
		Option.setType(optionElement, "logFile");
		Option.setValue(optionElement, pluginPath + sr + "config" + sr + "probekit.log");
		agentElement.appendChild(optionElement);
		
		/* Create the logLevel agent option */
		optionElement = doc.createElement(Option.TAG);
		Option.setName(optionElement, "ProbeAgentExtension");
		Option.setType(optionElement, "logLevel");
		Option.setValue(optionElement, "warning");
		agentElement.appendChild(optionElement);

		configFile.saveToFile();
	}

	public void printExamples() {
		/* Will not be used */
	}

	public void printHelp() {
		/* Will not be used */	
	}

}
