/********************************************************************** 
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: BuilderUtils.java,v 1.2 2006/02/06 20:18:16 nmehrega Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.tptp.platform.probekit.builder;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.tptp.platform.probekit.util.ProbekitConstants;
import org.eclipse.tptp.platform.probekit.util.ProbekitDebugConfig;


/**
 * @author kcoleman
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
class BuilderUtils {
	public static void trace(String message) 
	{
		if (ProbekitDebugConfig.TRACE_BUILDER) {
			System.out.println(message);
		}
	}
	
	/**
	 * Determine whether or not a resource is contained within a designated
	 * project source folder. For java projects (and every probe project is
	 * also a java project), source folders are classpath entries of type
	 * CPE_SOURCE. Anything else doesn't qualify.
	 * 
	 * Identifying whether or not a resource is part of a source folder is
	 * interesting because the java builder copies all non-java resources
	 * (like our .probe and .probescript files) into the output folders. We
	 * only want to consider one of each, so we need a way to distinguish the
	 * copies.
	 * 
	 * @param r The resource under consideration
	 * @return True if the target resource is contained in a project source folder,
	 * 		false otherwise.
	 */
	public static boolean isInSrcDir(IResource r)
	{
		IProject project = r.getProject();
		IPath rpath = r.getFullPath();
		IJavaProject jp = JavaCore.create(project);
		if ( jp != null ) {
			try {
				jp.getOutputLocation();
				IClasspathEntry[] entries = jp.getResolvedClasspath(true);
				for (int i = 0; i < entries.length; i++ ) {
					if ( entries[i].getEntryKind() == IClasspathEntry.CPE_SOURCE &&
							entries[i].getPath().isPrefixOf(rpath) ) {
						return true;
					}
				}
			} catch (Exception e)
			{
				// TODO beats me what we should really do in this case.
				return false;
			}
		}
		return false;
	}
	
	public static boolean isProbeSource(IResource r)
	{
		return r.getName().endsWith(ProbekitConstants.PROBE_SRC_EXT) &&
				isInSrcDir(r);
	}
}
