/********************************************************************** 
 * Copyright (c) 2004, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: RegistryConstants.java,v 1.2 2006/02/06 20:18:19 nmehrega Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 

package org.eclipse.tptp.platform.probekit.registry;

/**
 * This class just encapsulates registry specific constants.
 * 
 * @author kcoleman
 */
abstract class RegistryConstants {
	/**
	 * Name of the directory under the plugin save area where
	 * registry data can be persisted.
	 */
	static final String REGISTRY_ROOT = "registry";	//$NON-NLS-1$
	
	// All these _TAG constants are used in saving and restoring
	// registry state as XML.
	static final String REGISTRY_TAG = "registry";	//$NON-NLS-1$
	static final String ENTRY_TAG = "entry";		//$NON-NLS-1$
	static final String COUNTER_TAG = "counter";	//$NON-NLS-1$
	static final String ID_TAG = "id";				//$NON-NLS-1$
	static final String AUTHORED_TAG = "authored";	//$NON-NLS-1$
	static final String VERSION_TAG = "version";	//$NON-NLS-1$

}
