/********************************************************************** 
 * Copyright (c) 2004, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: InaccessibleProbeRsrcException.java,v 1.2 2006/02/06 20:18:15 nmehrega Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 

package org.eclipse.tptp.platform.probekit.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;

/**
 * Use this exception to signify an inaccessible IResource. But first, check
 * to see if InvalidProbeBundleException is a better choice. It can convey
 * similar information in a richer fashion.
 * 
 * @author kcoleman
 */
public class InaccessibleProbeRsrcException extends Exception {
    private static final long serialVersionUID = 3905521601116976944L;
    transient IResource offendingResource = null;

	/**
	 * 
	 */
	private InaccessibleProbeRsrcException() {
		super();
	}

	/**
	 * @param resource The resource that is inaccessible
	 */
	public InaccessibleProbeRsrcException(IResource resource) {
		super();
		offendingResource = resource;
	}

	/**
	 * @param resource the resource that is inaccessible
	 * @param cause more deail about the problem, as an embedded Throwable
	 */
	public InaccessibleProbeRsrcException(IResource resource, Throwable cause) {
		super(cause);
		offendingResource = resource;
	}
	
	/**
	 * Retrieve the IResource that was inaccessible.
	 * 
	 * @return The inaccessible resource that was the root cause of this exception.
	 */
	public IResource getOffendingResource() {
		return offendingResource;
	}
	
	private synchronized void writeObject(ObjectOutputStream s) throws IOException
	{
		s.defaultWriteObject();
		if ( offendingResource != null ) {
			s.writeObject(offendingResource.getFullPath().toString());
		} else {
			s.writeObject("null");
		}
	}
	
	private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException
	{
		s.defaultReadObject();
		String str = (String)s.readObject();
		if ( str == null || str.compareTo("null") == 0 ) {
			offendingResource = null;
		} else {
			// Attempt to restore from workspace relative resource path
			// A dangerous assumption here is that this is always a file
			// resource. It is true in the case of the registry.
			IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();		
			offendingResource = root.getFile(new Path(str));		}
	}
}
