/********************************************************************** 
 * Copyright (c) 2004, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: ProbeBundleBuildRequiredException.java,v 1.2 2006/02/06 20:18:15 nmehrega Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 

package org.eclipse.tptp.platform.probekit.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;

/**
 * @author kcoleman
 *
 */
public class ProbeBundleBuildRequiredException extends Exception {
    private static final long serialVersionUID = 3258697615129784882L;
    private transient IResource offendingResource = null;

	/**
	 * Keep callers from constructing an empty one
	 */
	private ProbeBundleBuildRequiredException() {
		super();
	}

	/**
	 * @param resource The probe source resource that has a problem.
	 */
	public ProbeBundleBuildRequiredException(IResource resource) {
		super("Resource " + resource + " needs to be rebuilt");		//$NON-NLS-1$
		offendingResource = resource;
	}
	
	public IResource getOffendingResource()
	{
		return offendingResource;
	}
	
	private synchronized void writeObject(ObjectOutputStream s) throws IOException
	{
		s.defaultWriteObject();
		if ( offendingResource != null ) {
			s.writeObject(offendingResource.getFullPath().toString());
		} else {
			s.writeObject("null");
		}
	}
	
	private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException
	{
		s.defaultReadObject();
		String str = (String)s.readObject();
		if ( str == null || str.compareTo("null") == 0 ) {
			offendingResource = null;
		} else {
			// Attempt to restore from workspace relative resource path
			// A dangerous assumption here is that this is always a file
			// resource. It is true in the case of the registry.
			IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();		
			offendingResource = root.getFile(new Path(str));		}
	}
}
