/********************************************************************** 
 * Copyright (c) 2004, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: ProbeBundleException.java,v 1.2 2006/02/06 20:18:15 nmehrega Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 

package org.eclipse.tptp.platform.probekit.util;

/**
 * Originally intended as the base class for all bundle related exceptions,
 * this has largely degenerated into a catchall for weird, internal error
 * kind of problems - corrupted resource properties, unexpectedly null
 * parameters, etc. Before using this class, you should look at
 * InvalidProbeBundleException and InaccessibleProbeRsrcException for
 * suitability. They carry more information and convey more meaning.
 * 
 * <p>This class doesn't override getLocalizedMessage(), so you are actively
 * discouraged from every emitting this as a string where users will see it.</p>
 *
 * @author kcoleman
 */
public class ProbeBundleException extends Exception {

    private static final long serialVersionUID = 3977582498085812534L;

	public ProbeBundleException() {
		super();
	}

	/**
	 * @param message
	 */
	public ProbeBundleException(String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param cause
	 */
	public ProbeBundleException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param cause
	 */
	public ProbeBundleException(Throwable cause) {
		super(cause);
	}

}
