/********************************************************************** 
 * Copyright (c) 2004, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: ProbekitConstants.java,v 1.2 2006/02/06 20:18:15 nmehrega Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 

package org.eclipse.tptp.platform.probekit.util;

/**
 * A home for shared probekit constants. 
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public abstract class ProbekitConstants {
	/**
	 * File extension for probekit source files. Remove this if the
	 * Hyades probekit grows a similar public constant.
	 */
	public static final String PROBE_SRC_EXT = ".probe";
	/**
	 * File extension for the probe script file generated by the
	 * probe compiler. Remove this if the Hyades probekit grows a
	 * similar public constant.
	 */
	public static final String PROBE_SCRIPT_EXT = ".probescript";
	/**
	 * File extension for probe set bundle files. This is the
	 * kind of file produced by export and consumed by import.
	 * Note: Currently configured to be ZIP files, but that will
	 * probably change later.
	 */
	// TODO Pick final probe bundle file extension
	public static final String PROBE_BUNDLE_EXT = ".zip";
	
	/**
	 * File extension for deployable probe class files generated
	 * by the probe compiler.
	 */
	public static final String CLASS_FILE_EXT = ".class";
	
	/**
	 * File extension for abbreviated probe model file that is part of an
	 * exported probe bundle. 
	 */
	public static final String PROBE_INFO_EXT = ".probeinfo";
	
	/**
	 * Package in which generated probe fragments reside. 
	 */
	public static final String PROBE_PACKAGE_NAME = "org.eclipse.tptp.platform.probekit.generatedClasses";
}
