/********************************************************************** 
 * Copyright (c) 2004, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: ProbekitDebugConfig.java,v 1.4 2007/04/18 01:27:23 jkubasta Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 

package org.eclipse.tptp.platform.probekit.util;

import org.eclipse.core.runtime.Platform;

/**
 * Debugging aids. In particular, code to manage turning on and off debug
 * tracing using the workbench's built in tracing facility. 
 * 
 * <p>The same option names defined here are also reflected in a .options file 
 * that is bundled with the plugin. Users can go into the launch config for
 * a runtime workbench, select the Tracing tab, enable tracing and select
 * one or more of these options for this plugin.</p>
 * 
 * <p>configure() need only be called once, at plugin startup. </p>
 * 
 * <p>To add a new tracing level:</p>
 * <ol>
 *   <li>Edit the .options file (top level of the project dir) and add an
 *       entry of the form: pluginid/debug/newoption = default_value.
 *       See .options for examples. The value need not be boolean.</li>
 *   <li>Edit this file to add OPT_TRACE_newoption. This should match what
 *       you put in the .options file, minus the plugin id.</li>
 *   <li>If this is a simple boolean option, edit this file to add a corresponding 
 *       TRACE_newoption variable to reflect the value.</li>
 *   <li>Edit the configure() method in this file to handle your new option as
 *       appropriate. For example, set TRACE_newoption.</li>
 * </ol>
 * 
 * 
 * @author kcoleman
 */
public class ProbekitDebugConfig {
	/**
	 * option name for enabling builder debugging
	 */
	public static final String OPT_TRACE_BUILDER = "/debug/builder";	//$NON-NLS-1$
	/**
	 * True when tracing of the probekit builder has been requested.
	 */
	public static boolean TRACE_BUILDER = false;
	
	/**
	 * option name for enabling registry debugging
	 */
	public static final String OPT_TRACE_REGISTRY = "/debug/registry";	//$NON-NLS-1$
	/**
	 * True when tracing of the probekit registry has been requested.
	 */
	public static boolean TRACE_REGISTRY = false;
	
	/*
	 * Tracing support for launch/deployment of probes to the piAgent.
	 * See org.eclipse.tptp.platform.probekit.launchpad.
	 */
	public static final String OPT_TRACE_LAUNCHPAD = "/debug/launchpad";	//$NON-NLS-1$	
	public static boolean TRACE_LAUNCHPAD = false;
	
	/*
	 * Tracing support for the probe source resource change listener. See
	 * org.eclipse.tptp.platform.probekit.util. ProbeSrcListener.
	 */
	public static final String OPT_TRACE_SRC_LISTENER = "/debug/sourceListener";	//$NON-NLS-1$
	public static boolean TRACE_SRC_LISTENER = false;
	
	public static void configure(String pluginId)
	{
		String option;
		
		option = Platform.getDebugOption(pluginId + OPT_TRACE_BUILDER);
		if ( option != null ) {
			TRACE_BUILDER = option.equalsIgnoreCase("true");	//$NON-NLS-1$
		}
		
		option = Platform.getDebugOption(pluginId + OPT_TRACE_REGISTRY);
		if ( option != null ) {
			TRACE_REGISTRY = option.equalsIgnoreCase("true");	//$NON-NLS-1$
		}
		
		option = Platform.getDebugOption(pluginId + OPT_TRACE_LAUNCHPAD);
		if ( option != null ) {
			TRACE_LAUNCHPAD = option.equalsIgnoreCase("true");	//$NON-NLS-1$
		}
		
		option = Platform.getDebugOption(pluginId + OPT_TRACE_SRC_LISTENER);
		if ( option != null ) {
			TRACE_SRC_LISTENER = option.equalsIgnoreCase("true");	//$NON-NLS-1$
		}
	}
}
