#!/bin/sh
#############################################################
# Copyright (c) 2005, 2006 IBM Corporation and others. 
# All rights reserved.   This program and the accompanying materials 
# are made available under the terms of the Eclipse Public License v1.0 
# which accompanies this distribution, and is available at 
# http://www.eclipse.org/legal/epl-v10.html         
# $Id: Instrument.sh,v 1.6 2006/03/24 21:58:56 hleung Exp $ 
#  
# Contributors: 
# IBM - Initial contribution
#############################################################

# Description:
# Driver script for simple probe testing. To use it, you need a probe
# file generated by the probe compiler and one class file. You cannot
# use this script for an app requiring multiple class files.
#
# PROBE_HOME should point to a directory containing the generated 
# files (probekit.jar and probekit.txt). ProbeInstrumenter should be locatable
# somewhere on your path. The targetted class file should be in the
# current working directory or specified by full pathname (minus the
# .class extension).
#########################################################

probecmd=Probekit.txt
probejar=Probekit.jar
probeinstr=ProbeInstrumenter

Usage() {
   cat <<-EOF
   ERROR: $@

   Syntax: cmd class_name

   The file <class_name>.class must be in the current directory.
   The $probeinstr executable must be on your path.

   Set PROBE_HOME in your environment to the directory containing 
   the generated $probejar and $probecmd files.
EOF
   exit 1
}

###
# CheckSetup class_name
#
# Sanity check the command line and environment. Silly stuff like can we
# find the specified class file, is PROBE_HOME set, etc.
###
CheckSetup() {
    infile=$1.class
    if [ ! -f $infile ]; then
       Usage "Cannot locate class file $infile"
    fi

    if [ "$PROBE_HOME" = "" ]; then
       Usage "PROBE_HOME not set in your environment"
    fi
    if [ ! -d $PROBE_HOME ]; then
       Usage "Cannot find directory $PROBE_HOME"
    fi

    if [ ! -r $PROBE_HOME/$probecmd ]; then
       Usage "Cannot find $PROBE_HOME/$probecmd"
    fi
}

#####################

if [ $# = 0 ]; then
   Usage "You must supply at least one class name"
fi
CheckSetup $1

echo "Instrumenting $class"
$probeinstr $PROBE_HOME/$probecmd $infile
if [ $? != 0 ]; then
   echo "ERROR: Instrumentation failure"
   exit 1
fi
echo "$infile instrumented."

echo "Renaming original to .bak and .bci to original"
mv -f $infile $infile.bak
mv -f $infile.bci $infile

status=0
echo "Executing $1"
java -cp ".:$CLASSPATH:$PROBE_HOME/$probejar" $1
if [ $? != 0 ]; then
   echo "ERROR: Execution failure"
   status=1
fi

echo "Restoring plain/BCI versions of class files"
mv -f $infile $infile.bci
mv -f $infile.bak $infile

echo "Finished"

exit $status
