 /********************************************************************** 
 * Copyright (c) 2008, 2010 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id:$ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 


#include "JVMUtils.h"


//------------------------------------------------------------------------------
int createJVM(JavaVM *jvm, JNIEnv **env)
{
	DLL_REFERENCE jvmLib;
	CreateJavaVM vmCreate;
	jint result;
 	
	 // Load the dynamic library.
	if(!(jvmLib = LOAD_LIBRARY(DLL_NAME))) return JVM_LOAD_ERROR;


	// Resolve the entry point. 
	if(!(vmCreate = (CreateJavaVM) RESOLVE_ENTRY_POINT(jvmLib, "JNI_CreateJavaVM"))) {
		return JVM_RESOLVE_ERROR;
	}

 #ifdef JNI_VERSION_1_2
     JavaVMInitArgs vm_args;
	 vm_args.version = 0x00010002;
     vm_args.options = new JavaVMOption[0];
     vm_args.nOptions = 0;
     vm_args.ignoreUnrecognized = JNI_TRUE;
     result = (*vmCreate)(&jvm, (void **)env, (void*)&vm_args);
 #else

     JDK1_1InitArgs vm_args;
     vm_args.version = 0x00010001;
     JNI_GetDefaultJavaVMInitArgs(&vm_args);
     result = (*vmCreate)(&jvm, *env, (void*)&vm_args);
 #endif /* JNI_VERSION_1_2 */
	 	// Instantiate the JVM, and clean up. 

	
	return (result == 0) ? 0 : JVM_CREATION_ERROR;
}
