 /********************************************************************** 
 * Copyright (c) 2008, 2010 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id:$ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 

#include <jni.h>
#include <stdlib.h>
#include "CommonDef.h"
/*******************************************************************************
 * The following macros are copied from Porting.h in the ProbeAgentExtension
 * They let us use LOAD_LIBRARY on all platforms. (Except AS/400?)
 */

#ifdef _WIN32
 #define DLL_REFERENCE HINSTANCE
 #define DLL_NAME "jvm"
 #define RESOLVE_ENTRY_POINT(mod, entry) GetProcAddress(mod, entry)
 #define LOAD_LIBRARY(name) LoadLibrary(name)
#elif MVS
 #include <dll.h>
 #define DLL_REFERENCE dllhandle *
 #define DLL_NAME "libjava.so"
 #define RESOLVE_ENTRY_POINT(mod, entry) dllqueryfn(mod, entry)
 #define LOAD_LIBRARY(name) dllload(name)
#elif _HPUX
 #include <dlfcn.h>
 #define DLL_REFERENCE void *
 #define DLL_NAME "libjvm.sl"
 #define RESOLVE_ENTRY_POINT(mod, entry) dlsym(mod, entry)
 #define LOAD_LIBRARY(name) dlopen(name, RTLD_LAZY)
#elif __OS400__
 #define DLL_REFERENCE void * 
 #define DLL_NAME "libjvm"
 #define RESOLVE_ENTRY_POINT(mod, entry) findServicePgmEntry(mod, entry)
 #define LOAD_LIBRARY(name) loadServicePgm(name)
#else
 #include <dlfcn.h>
 #define DLL_REFERENCE void * 
 #define DLL_NAME "libjvm.so"
 #define RESOLVE_ENTRY_POINT(mod, entry) dlsym(mod, entry)
 #define LOAD_LIBRARY(name) dlopen(name, RTLD_LAZY)
#endif

#define	JVM_LOAD_ERROR		1
#define	JVM_RESOLVE_ERROR	2
#define	JVM_CREATION_ERROR	3

typedef jint (JNICALL *CreateJavaVM)(JavaVM**, void**, void*);

int createJVM(JavaVM *jvm, JNIEnv **env);
