/********************************************************************** 
 * Copyright (c) 2005, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: porting.h,v 1.12 2009/11/21 22:19:34 jwest Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 


/*******************************************************************************
 *
 * porting.h: portability header for ProbeAgentExtension project
 */

/*******************************************************************************
 * The following macros are copied from JvmpiWriter.c in the Hyades project.
 * They let us use LOAD_LIBRARY on all platforms. (Except AS/400?)
 */

#ifdef _WIN32
 #define MODULE_REFERENCE HMODULE
 #define DLL_REFERENCE HINSTANCE
 #define DLL_NAME "jvm"
 #define RESOLVE_MODULE(name) GetModuleHandle(name)
 #define LOAD_LIBRARY(name) LoadLibrary(name)
 #define DLERROR() "not available"
 #define RESOLVE_ENTRY_POINT(mod, entry) GetProcAddress(mod, entry)
 #define ATTACH_THREAD(env) (*_jvmpiAgent_jvm)->AttachCurrentThread(_jvmpiAgent_jvm,  (void**)&env, NULL)
 #define DETACH_THREAD() (*_jvmpiAgent_jvm)->DetachCurrentThread(_jvmpiAgent_jvm)
 #ifndef CDECL
   #define CDECL __cdecl
 #endif
#elif MVS
 #include <dll.h>
 #define MODULE_REFERENCE dllhandle *
 #define DLL_REFERENCE dllhandle *
 #define DLL_NAME "libjava.so"
 #define RESOLVE_MODULE(name) dllload(name)
 #define LOAD_LIBRARY(name) dllload(name)
 #define DLERROR() "not available"
 #define RESOLVE_ENTRY_POINT(mod, entry) dllqueryfn(mod, entry)
 #define ATTACH_THREAD(env) (*_jvmpiAgent_jvm)->AttachCurrentThread(_jvmpiAgent_jvm,  (void**)&env, NULL)
 #define DETACH_THREAD() (*_jvmpiAgent_jvm)->DetachCurrentThread(_jvmpiAgent_jvm)
 #ifndef CDECL
  #define CDECL
 #endif
#elif _HPUX
 #include <dlfcn.h>
 #define MODULE_REFERENCE void *
 #define DLL_REFERENCE void *
 #define DLL_NAME "libjvm.sl"
 #define RESOLVE_MODULE(name) dlopen(name, RTLD_LAZY)
 #define LOAD_LIBRARY(name) dlopen(name, RTLD_LAZY)
 #define DLERROR() dlerror()
 #define RESOLVE_ENTRY_POINT(mod, entry) dlsym(mod, entry)
 #ifdef __cplusplus
   # With HP JDK, defns vary, depending on C vs C++. 
   #define ATTACH_THREAD(env) \
     (_jvmpiAgent_jvm)->AttachCurrentThread((void**)&env, NULL)
   #define DETACH_THREAD() (_jvmpiAgent_jvm)->DetachCurrentThread()
 #else /* !__cplusplus */
   #define ATTACH_THREAD(env) \
     (*_jvmpiAgent_jvm)->AttachCurrentThread(_jvmpiAgent_jvm, (void**)&env, NULL)
   #define DETACH_THREAD() \
     (*_jvmpiAgent_jvm)->DetachCurrentThread(_jvmpiAgent_jvm)
 #endif /* __cplusplus */
 #ifndef CDECL
  #define CDECL
 #endif
#elif __OS400__
 #define MODULE_REFERENCE void *
 #define DLL_REFERENCE void *
 #define DLL_NAME "libjvm"
 #define RESOLVE_MODULE(name) loadServicePgm(name)
 #define LOAD_LIBRARY(name) loadServicePgm(name)
 #define DLERROR() "not available"
 #define RESOLVE_ENTRY_POINT(mod, entry) findServicePgmEntry(mod, entry)
 #define ATTACH_THREAD(env) (*_jvmpiAgent_jvm)->AttachCurrentThread(_jvmpiAgent_jvm,  (void**)&env, NULL)
 #define DETACH_THREAD() (*_jvmpiAgent_jvm)->DetachCurrentThread(_jvmpiAgent_jvm)
 #ifndef CDECL
  #define CDECL
 #endif
#else
 #include <dlfcn.h>
 #define MODULE_REFERENCE void *
 #define DLL_REFERENCE void *
 #define DLL_NAME "libjvm.so"
 #define RESOLVE_MODULE(name) dlopen(name, RTLD_LAZY)
 #define LOAD_LIBRARY(name) dlopen(name, RTLD_LAZY)
 #define DLERROR() dlerror()
 #define RESOLVE_ENTRY_POINT(mod, entry) dlsym(mod, entry)
 #define ATTACH_THREAD(env) (*_jvmpiAgent_jvm)->AttachCurrentThread(_jvmpiAgent_jvm,  (void**)&env, NULL)
 #define DETACH_THREAD() (*_jvmpiAgent_jvm)->DetachCurrentThread(_jvmpiAgent_jvm)
 #ifndef CDECL
  #define CDECL
 #endif
#endif

#ifdef _WIN32
 #define STRICOLL _stricoll		/* Case insensitive on Windows */
#else
 #define STRICOLL strcoll		/* Case sensitive on other platforms */
#endif

/*******************************************************************************
 * platform-indepdendent locking logic
 * copied from lock3.c / lock3.h from the Eclipse Hyades RAC project
 * org.eclipse.hyades.datacollection
 */

#ifdef _WIN32
#include <windows.h>

// The single-writer/multiple-reader guard
// compound synchronization object
typedef struct _SWMR {
   // This critical section guards access to the other objects
   // managed by this data structure and also indicates
   // whether any writer threads are writing.
   CRITICAL_SECTION cs;

   // This manual-reset event is signaled when
   // no reader threads are reading.
   HANDLE hEventNoReaders;

   LONG numReaders;
} Lock_t;



#else
  #include <pthread.h>
  #include "RAComm.h"

#if defined _LINUX_X86 || defined _LINUX_X86_64 || defined _LINUX_390 || defined _HPUX || defined _LINUX_PPC64 || (defined(__s390__) && defined(__linux__)) || defined _SOLARIS || defined _SOLARISX86
  typedef struct {
    pthread_mutex_t mutex;
    pthread_cond_t  rcond;
    pthread_cond_t  wcond;
    long readCount;
    short waiting_writers;
    short active_writers;
  } Lock_t;
#else
  typedef pthread_rwlock_t Lock_t;
#endif

#endif


#if defined __cplusplus && defined _HPUX
extern "C" {
#endif

/** Initializes a SWMRG structure. This structure must be
	initialized before any writer or reader threads attempt
	to wait on it.
	The structure must be allocated by the application and
	the structure's address is passed as the first parameter.
	The lpszName parameter is the name of the object. Pass
	NULL if you do not want to share the object.
  */
extern BOOL  initializeLock (Lock_t *lock);


/** Deletes the system resources associated with a SWMRG
	structure. The structure must be deleted only when
	no writer or reader threads in the calling process
	will wait on it.
  */
extern void deleteLock (Lock_t *lock);

/** A writer thread calls this function to know when
	it can successfully write to the shared data.
  */
extern int getWriteLock (Lock_t *lock);


/** A writer thread calls this function to let other threads
	know that it no longer needs to write to the shared data.
  */
extern void releaseWriteLock (Lock_t *lock);


/** A reader thread calls this function to know when
	it can successfully read the shared data.
  */
extern int getReadLock(Lock_t *lock);


/** A reader thread calls this function to let other threads
	know when it no longer needs to read the shared data.
  */
extern void releaseReadLock (Lock_t *lock);

#if defined __cplusplus && defined _HPUX
}
#endif
