/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SetConfig.java,v 1.14 2008/01/24 13:50:08 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.core;

import org.eclipse.tptp.platform.agentcontroller.config.AgentControllerEnvironment;
import org.eclipse.tptp.platform.agentcontroller.config.Option;
import org.eclipse.tptp.platform.agentcontroller.config.PluginConfig;
import org.eclipse.tptp.platform.agentcontroller.config.SetConfigSkeleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetConfig extends SetConfigSkeleton {

	public void askUser() {
		// This method is not being used
	}

	public void generateConfiguration() {
		Document doc;
		Element holder;
		Element pConfig;

		Element aEnv;
		Element option;

		//
		// Standard initializer 
		//
		doc = configFile.getDoc();
		if(doc == null) {
			return;
		}

		pConfig = doc.createElement(PluginConfig.TAG);
		holder = configFile.getHolder();
		holder.appendChild(pConfig);
		PluginConfig.setRequires(pConfig, "org.eclipse.hyades.execution, org.eclipse.hyades.logging.core");

		//
		// Plugin specific information
		//
		aEnv = doc.createElement(AgentControllerEnvironment.TAG);
		AgentControllerEnvironment.setConfiguration(aEnv, "default");
		pConfig.appendChild(aEnv);
		
		//
		// The following can be reused for other plugins
		//
		option = doc.createElement(Option.TAG);
		Option.setType(option, "version");
		if(getPluginName().indexOf('_') != -1) {
			Option.setName(option, getPluginName().substring(0, getPluginName().lastIndexOf('_')));
			Option.setValue(option, getPluginName().substring(getPluginName().lastIndexOf('_') + 1));
		}
		else {
			Option.setName(option, getPluginName());
			Option.setValue(option, "unknown");
		}
		pConfig.appendChild(option);

		configFile.saveToFile();
	}

	public void printHelp() {
	}

	public void printExamples() {
	}
}
