/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecorderEnvironmentAdapter.java,v 1.3 2007/05/03 01:23:35 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.remote;

import java.io.File;
import java.io.IOException;

import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IOrderedProperty;
import org.eclipse.hyades.execution.core.impl.OrderedPropertyImpl;

/**
 * object to be implemented by objects which will setup the execution environment for a recorder
 * @author Ernest Jessee
 */
public abstract class RecorderEnvironmentAdapter
{
	
	protected String deploymentPath = null;
	
	
	/**
	 * Sets the deploymentPath, then calls getClassPathEntry(String).  This is called directly by the recorder framework.
	 * 
	 * It is adviseable for new implementors to override this method, rather than using the abstract class, which is deprecated
	 * and will be removed in TPTP 5. 
	 * @param deployPath
	 * @return
	 */
	protected String getClassPathEntry(String deployPath)
	{
		deploymentPath = deployPath;
		return getClassPathEntry();
	}
	/**
	 * This method has been retained so as not to break API.
	 * As of TPTP 4.1, framework calls getClassPathEntry(String), where String is the path to the directory of files to deploy
	 * To determine the classpath of the deployed files, call getDeploymentPath().
	 * 
	 * It is adviseable for new implementors to override the getClassPathEntry(String) method, 
	 * rather than using the abstract class, which is deprecated
	 * and will be removed in TPTP 5. 
	 * @return
	 * @deprecated
	 */
	protected abstract String getClassPathEntry();
	
	/**
	 * required for deployment.  Returns an array of java.io.File objects to be deployed.
	 * @return
	 */
	public java.io.File[] getRecorderJARs()
	{
		return new File[0];
	}
	
	public void setupExecutionEnvironment(IExecutionEnvironment env, String deployPath) throws IOException
	{
		appendClassPath(env, deployPath);
	
	}
	
	private void appendClassPath(IExecutionEnvironment environment, String deployPath)
			throws IOException
	{
		String classPathEntry = getClassPathEntry(deployPath);
		if(classPathEntry!=null && classPathEntry!="") //$NON-NLS-1$
		{
			String classPathTag = "CLASSPATH"; //$NON-NLS-1$
		
			IOrderedProperty property = environment.getEnvByName(classPathTag);
			if(property == null)
			{
				property = new OrderedPropertyImpl();
				property.setName(classPathTag);
			}
					
			property.appendValue(classPathEntry);
		
			
			environment.setEnv(property);
		}
	}
	/**
	 * @return Returns the deploymentPath.
	 */
	public String getDeploymentPath() {
		return deploymentPath;
	}
	
}
