/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecorderExecutableObjectAdapter.java,v 1.2 2008/01/21 20:05:11 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.remote;

import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;

/**
 * object to be extended by objects which will setup the VMArgs etc for recorder executables
 * @author Ernest Jessee
 */
public abstract class RecorderExecutableObjectAdapter
{

	public abstract String getAgentClassPath();
	
	public abstract String getVMArgString();
	
	public void setupExecutableObject(JavaProcessExecutableObjectStub javaExecutableObject)
	{					
		//TODO handle empty classpath
		String vmArgs = getVMArgString().trim();
		String agentClassPath = getAgentClassPath().trim();
		javaExecutableObject.setArgs(vmArgs+" org.eclipse.hyades.internal.execution.recorder.remote.RecorderAgentController "+agentClassPath); //$NON-NLS-1$
	}

}
